/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.nio.BufferUnderflowException;
import java.util.Collection;
import java.util.Set;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQPInvalidClassException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.MessageMetaDataType_0_8;
import org.apache.qpid.server.protocol.v0_8.transport.AMQProtocolVersionException;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class MessageMetaData
implements StorableMessageMetaData {
    private final MessagePublishInfo _messagePublishInfo;
    private final ContentHeaderBody _contentHeaderBody;
    private long _arrivalTime;
    private static final byte MANDATORY_FLAG = 1;
    private static final byte IMMEDIATE_FLAG = 2;
    public static final MessageMetaDataType.Factory<MessageMetaData> FACTORY = new MetaDataFactory();
    private static final MessageMetaDataType_0_8 TYPE = new MessageMetaDataType_0_8();

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody) {
        this(publishBody, contentHeaderBody, System.currentTimeMillis());
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, long arrivalTime) {
        this._contentHeaderBody = contentHeaderBody;
        this._messagePublishInfo = publishBody;
        this._arrivalTime = arrivalTime;
    }

    public synchronized ContentHeaderBody getContentHeaderBody() {
        return this._contentHeaderBody;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public MessageMetaDataType getType() {
        return TYPE;
    }

    public int getStorableSize() {
        int size = this._contentHeaderBody.getSize();
        size += 4;
        size += EncodingUtils.encodedShortStringLength((AMQShortString)this._messagePublishInfo.getExchange());
        size += EncodingUtils.encodedShortStringLength((AMQShortString)this._messagePublishInfo.getRoutingKey());
        ++size;
        return size += EncodingUtils.encodedLongLength();
    }

    public void writeToBuffer(QpidByteBuffer dest) {
        dest.putInt(this._contentHeaderBody.getSize());
        this._contentHeaderBody.writePayload(dest);
        EncodingUtils.writeShortStringBytes((QpidByteBuffer)dest, (AMQShortString)this._messagePublishInfo.getExchange());
        EncodingUtils.writeShortStringBytes((QpidByteBuffer)dest, (AMQShortString)this._messagePublishInfo.getRoutingKey());
        byte flags = 0;
        if (this._messagePublishInfo.isMandatory()) {
            flags = (byte)(flags | 1);
        }
        if (this._messagePublishInfo.isImmediate()) {
            flags = (byte)(flags | 2);
        }
        dest.put(flags);
        dest.putLong(this._arrivalTime);
    }

    public int getContentSize() {
        return (int)this._contentHeaderBody.getBodySize();
    }

    public boolean isPersistent() {
        return this._contentHeaderBody.getProperties().getDeliveryMode() == 2;
    }

    public synchronized void dispose() {
        this._contentHeaderBody.dispose();
    }

    public synchronized void clearEncodedForm() {
        this._contentHeaderBody.clearEncodedForm();
    }

    public synchronized void reallocate() {
        this._contentHeaderBody.reallocate();
    }

    public synchronized void validate() {
        this._contentHeaderBody.getProperties().validate();
    }

    public AMQMessageHeader getMessageHeader() {
        return new MessageHeaderAdapter();
    }

    private final class MessageHeaderAdapter
    implements AMQMessageHeader {
        private MessageHeaderAdapter() {
        }

        private BasicContentHeaderProperties getProperties() {
            return MessageMetaData.this.getContentHeaderBody().getProperties();
        }

        public String getUserId() {
            return this.getProperties().getUserIdAsString();
        }

        public String getAppId() {
            return this.getProperties().getAppIdAsString();
        }

        public String getGroupId() {
            String jmsXGroupId = this.getProperties().getHeaders().getString("JMSXGroupID");
            return jmsXGroupId == null ? null : jmsXGroupId;
        }

        public String getCorrelationId() {
            return this.getProperties().getCorrelationIdAsString();
        }

        public long getExpiration() {
            return this.getProperties().getExpiration();
        }

        public String getMessageId() {
            return this.getProperties().getMessageIdAsString();
        }

        public String getMimeType() {
            return this.getProperties().getContentTypeAsString();
        }

        public String getEncoding() {
            return this.getProperties().getEncodingAsString();
        }

        public byte getPriority() {
            return this.getProperties().getPriority();
        }

        public long getTimestamp() {
            return this.getProperties().getTimestamp();
        }

        public String getType() {
            return this.getProperties().getTypeAsString();
        }

        public String getReplyTo() {
            return this.getProperties().getReplyToAsString();
        }

        public long getNotValidBefore() {
            Object header = this.getHeader("x-qpid-not-valid-before");
            return header instanceof Number ? ((Number)header).longValue() : 0L;
        }

        public Object getHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.get(name);
        }

        public boolean containsHeaders(Set<String> names) {
            FieldTable ft = this.getProperties().getHeaders();
            for (String name : names) {
                if (ft.containsKey(name)) continue;
                return false;
            }
            return true;
        }

        public Collection<String> getHeaderNames() {
            return this.getProperties().getHeaders().keys();
        }

        public boolean containsHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.containsKey(name);
        }
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MessageMetaData> {
        private MetaDataFactory() {
        }

        public MessageMetaData createMetaData(QpidByteBuffer buf) {
            try {
                int size = buf.getInt();
                ContentHeaderBody chb = ContentHeaderBody.createFromBuffer(buf, size);
                AMQShortString exchange = AMQShortString.readAMQShortString((QpidByteBuffer)buf);
                AMQShortString routingKey = AMQShortString.readAMQShortString((QpidByteBuffer)buf);
                byte flags = buf.get();
                long arrivalTime = buf.getLong();
                MessagePublishInfo publishBody = new MessagePublishInfo(exchange, (flags & 2) != 0, (flags & 1) != 0, routingKey);
                return new MessageMetaData(publishBody, chb, arrivalTime);
            }
            catch (IllegalArgumentException | IllegalStateException | BufferUnderflowException | AMQFrameDecodingException | AMQPInvalidClassException | AMQProtocolVersionException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
        }
    }
}

