/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;

public class QueueUnbindBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 50;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final FieldTable _arguments;

    public QueueUnbindBody(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 50;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueUnbind(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueUnbindBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) throws AMQFrameDecodingException {
        int ticket = buffer.getUnsignedShort();
        AMQShortString queue = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        AMQShortString exchange = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        AMQShortString routingKey = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        FieldTable arguments = EncodingUtils.readFieldTable((QpidByteBuffer)buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueUnbind(queue, exchange, routingKey, arguments);
        }
        if (arguments != null) {
            arguments.clearEncodedForm();
        }
    }
}

