/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.util.Arrays;
import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerMethodProcessor;

public class ConnectionSecureOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 21;
    private final byte[] _response;

    public ConnectionSecureOkBody(byte[] response) {
        this._response = response;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    public final byte[] getResponse() {
        return this._response;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._response);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeBytes(buffer, this._response);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionSecureOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionSecureOkBodyImpl: ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer in, ServerMethodProcessor dispatcher) {
        byte[] response = EncodingUtils.readBytes((QpidByteBuffer)in);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionSecureOk(response);
        }
    }
}

