/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.util.Map;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AccessRequestBody;
import org.apache.qpid.server.protocol.v0_8.transport.AccessRequestOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicAckBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicCancelBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicCancelOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicConsumeBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicConsumeOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicDeliverBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetEmptyBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicPublishBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicQosBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicQosOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverSyncBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverSyncOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRejectBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicReturnBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelAlertBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelCloseBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelCloseOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelFlowBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelFlowOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelOpenBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelOpenOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionCloseBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionCloseOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionOpenBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionOpenOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionRedirectBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionSecureBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionSecureOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionStartBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionStartOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionTuneBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionTuneOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeBoundBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeBoundOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeclareBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeclareOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeleteBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeleteOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueBindBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueBindOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeclareBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeclareOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeleteBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeleteOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueuePurgeBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueuePurgeOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueUnbindBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueUnbindOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxCommitBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxCommitOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxRollbackBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxRollbackOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxSelectBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxSelectOkBody;

public final class MethodRegistry {
    private ProtocolVersion _protocolVersion;

    public MethodRegistry(ProtocolVersion pv) {
        this._protocolVersion = pv;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public final AccessRequestBody createAccessRequestBody(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
        return new AccessRequestBody(realm, exclusive, passive, active, write, read);
    }

    public final AccessRequestOkBody createAccessRequestOkBody(int ticket) {
        return new AccessRequestOkBody(ticket);
    }

    public final BasicQosBody createBasicQosBody(long prefetchSize, int prefetchCount, boolean global) {
        return new BasicQosBody(prefetchSize, prefetchCount, global);
    }

    public final BasicQosOkBody createBasicQosOkBody() {
        return new BasicQosOkBody();
    }

    public final BasicConsumeBody createBasicConsumeBody(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, Map<String, Object> arguments) {
        return new BasicConsumeBody(ticket, AMQShortString.valueOf((String)queue), AMQShortString.valueOf((String)consumerTag), noLocal, noAck, exclusive, nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final BasicConsumeOkBody createBasicConsumeOkBody(AMQShortString consumerTag) {
        return new BasicConsumeOkBody(consumerTag);
    }

    public final BasicCancelBody createBasicCancelBody(AMQShortString consumerTag, boolean nowait) {
        return new BasicCancelBody(consumerTag, nowait);
    }

    public final BasicCancelOkBody createBasicCancelOkBody(AMQShortString consumerTag) {
        return new BasicCancelOkBody(consumerTag);
    }

    public final BasicPublishBody createBasicPublishBody(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
        return new BasicPublishBody(ticket, AMQShortString.valueOf((String)exchange), AMQShortString.valueOf((String)routingKey), mandatory, immediate);
    }

    public final BasicReturnBody createBasicReturnBody(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
        return new BasicReturnBody(replyCode, replyText, exchange, routingKey);
    }

    public final BasicDeliverBody createBasicDeliverBody(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey) {
        return new BasicDeliverBody(consumerTag, deliveryTag, redelivered, exchange, routingKey);
    }

    public final BasicGetBody createBasicGetBody(int ticket, AMQShortString queue, boolean noAck) {
        return new BasicGetBody(ticket, queue, noAck);
    }

    public final BasicGetOkBody createBasicGetOkBody(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
        return new BasicGetOkBody(deliveryTag, redelivered, exchange, routingKey, messageCount);
    }

    public final BasicGetEmptyBody createBasicGetEmptyBody(AMQShortString clusterId) {
        return new BasicGetEmptyBody(clusterId);
    }

    public final BasicAckBody createBasicAckBody(long deliveryTag, boolean multiple) {
        return new BasicAckBody(deliveryTag, multiple);
    }

    public final BasicRejectBody createBasicRejectBody(long deliveryTag, boolean requeue) {
        return new BasicRejectBody(deliveryTag, requeue);
    }

    public final BasicRecoverBody createBasicRecoverBody(boolean requeue) {
        return new BasicRecoverBody(requeue);
    }

    public final BasicRecoverSyncOkBody createBasicRecoverSyncOkBody() {
        return new BasicRecoverSyncOkBody(this._protocolVersion);
    }

    public final BasicRecoverSyncBody createBasicRecoverSyncBody(boolean requeue) {
        return new BasicRecoverSyncBody(this._protocolVersion, requeue);
    }

    public final ChannelAlertBody createChannelAlertBody(int replyCode, AMQShortString replyText, FieldTable details) {
        return new ChannelAlertBody(replyCode, replyText, details);
    }

    public final ChannelOpenBody createChannelOpenBody(AMQShortString outOfBand) {
        return new ChannelOpenBody();
    }

    public final ChannelOpenOkBody createChannelOpenOkBody(byte[] channelId) {
        return this.createChannelOpenOkBody();
    }

    public final ChannelOpenOkBody createChannelOpenOkBody() {
        return this._protocolVersion.equals((Object)ProtocolVersion.v0_8) ? ChannelOpenOkBody.INSTANCE_0_8 : ChannelOpenOkBody.INSTANCE_0_9;
    }

    public final ChannelFlowBody createChannelFlowBody(boolean active) {
        return new ChannelFlowBody(active);
    }

    public final ChannelFlowOkBody createChannelFlowOkBody(boolean active) {
        return new ChannelFlowOkBody(active);
    }

    public final ChannelCloseBody createChannelCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        return new ChannelCloseBody(replyCode, replyText, classId, methodId);
    }

    public final ChannelCloseOkBody createChannelCloseOkBody() {
        return ChannelCloseOkBody.INSTANCE;
    }

    public final ConnectionStartBody createConnectionStartBody(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        return new ConnectionStartBody(versionMajor, versionMinor, serverProperties, mechanisms, locales);
    }

    public final ConnectionStartOkBody createConnectionStartOkBody(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        return new ConnectionStartOkBody(clientProperties, mechanism, response, locale);
    }

    public final ConnectionSecureBody createConnectionSecureBody(byte[] challenge) {
        return new ConnectionSecureBody(challenge);
    }

    public final ConnectionSecureOkBody createConnectionSecureOkBody(byte[] response) {
        return new ConnectionSecureOkBody(response);
    }

    public final ConnectionTuneBody createConnectionTuneBody(int channelMax, long frameMax, int heartbeat) {
        return new ConnectionTuneBody(channelMax, frameMax, heartbeat);
    }

    public final ConnectionTuneOkBody createConnectionTuneOkBody(int channelMax, long frameMax, int heartbeat) {
        return new ConnectionTuneOkBody(channelMax, frameMax, heartbeat);
    }

    public final ConnectionOpenBody createConnectionOpenBody(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        return new ConnectionOpenBody(virtualHost, capabilities, insist);
    }

    public final ConnectionOpenOkBody createConnectionOpenOkBody(AMQShortString knownHosts) {
        return new ConnectionOpenOkBody(knownHosts);
    }

    public final ConnectionRedirectBody createConnectionRedirectBody(AMQShortString host, AMQShortString knownHosts) {
        return new ConnectionRedirectBody(this._protocolVersion, host, knownHosts);
    }

    public final ConnectionCloseBody createConnectionCloseBody(int replyCode, AMQShortString replyText, int classId, int methodId) {
        return new ConnectionCloseBody(this._protocolVersion, replyCode, replyText, classId, methodId);
    }

    public final ConnectionCloseOkBody createConnectionCloseOkBody() {
        return ProtocolVersion.v0_8.equals((Object)this._protocolVersion) ? ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_8 : ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_9;
    }

    public final ExchangeDeclareBody createExchangeDeclareBody(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, Map<String, Object> arguments) {
        return new ExchangeDeclareBody(ticket, AMQShortString.valueOf((String)exchange), AMQShortString.valueOf((String)type), passive, durable, autoDelete, internal, nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final ExchangeDeclareOkBody createExchangeDeclareOkBody() {
        return new ExchangeDeclareOkBody();
    }

    public final ExchangeDeleteBody createExchangeDeleteBody(int ticket, String exchange, boolean ifUnused, boolean nowait) {
        return new ExchangeDeleteBody(ticket, AMQShortString.valueOf((String)exchange), ifUnused, nowait);
    }

    public final ExchangeDeleteOkBody createExchangeDeleteOkBody() {
        return new ExchangeDeleteOkBody();
    }

    public final ExchangeBoundBody createExchangeBoundBody(String exchange, String routingKey, String queue) {
        return new ExchangeBoundBody(AMQShortString.valueOf((String)exchange), AMQShortString.valueOf((String)routingKey), AMQShortString.valueOf((String)queue));
    }

    public final ExchangeBoundOkBody createExchangeBoundOkBody(int replyCode, AMQShortString replyText) {
        return new ExchangeBoundOkBody(replyCode, replyText);
    }

    public final QueueDeclareBody createQueueDeclareBody(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, Map<String, Object> arguments) {
        return new QueueDeclareBody(ticket, AMQShortString.valueOf((String)queue), passive, durable, exclusive, autoDelete, nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final QueueDeclareOkBody createQueueDeclareOkBody(AMQShortString queue, long messageCount, long consumerCount) {
        return new QueueDeclareOkBody(queue, messageCount, consumerCount);
    }

    public final QueueBindBody createQueueBindBody(int ticket, String queue, String exchange, String routingKey, boolean nowait, Map<String, Object> arguments) {
        return new QueueBindBody(ticket, AMQShortString.valueOf((String)queue), AMQShortString.valueOf((String)exchange), AMQShortString.valueOf((String)routingKey), nowait, FieldTable.convertToFieldTable(arguments));
    }

    public final QueueBindOkBody createQueueBindOkBody() {
        return new QueueBindOkBody();
    }

    public final QueuePurgeBody createQueuePurgeBody(int ticket, AMQShortString queue, boolean nowait) {
        return new QueuePurgeBody(ticket, queue, nowait);
    }

    public final QueuePurgeOkBody createQueuePurgeOkBody(long messageCount) {
        return new QueuePurgeOkBody(messageCount);
    }

    public final QueueDeleteBody createQueueDeleteBody(int ticket, String queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
        return new QueueDeleteBody(ticket, AMQShortString.valueOf((String)queue), ifUnused, ifEmpty, nowait);
    }

    public final QueueDeleteOkBody createQueueDeleteOkBody(long messageCount) {
        return new QueueDeleteOkBody(messageCount);
    }

    public final QueueUnbindBody createQueueUnbindBody(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, FieldTable arguments) {
        return new QueueUnbindBody(ticket, queue, exchange, routingKey, arguments);
    }

    public final QueueUnbindOkBody createQueueUnbindOkBody() {
        return new QueueUnbindOkBody();
    }

    public final TxSelectBody createTxSelectBody() {
        return TxSelectBody.INSTANCE;
    }

    public final TxSelectOkBody createTxSelectOkBody() {
        return TxSelectOkBody.INSTANCE;
    }

    public final TxCommitBody createTxCommitBody() {
        return TxCommitBody.INSTANCE;
    }

    public final TxCommitOkBody createTxCommitOkBody() {
        return TxCommitOkBody.INSTANCE;
    }

    public final TxRollbackBody createTxRollbackBody() {
        return TxRollbackBody.INSTANCE;
    }

    public final TxRollbackOkBody createTxRollbackOkBody() {
        return TxRollbackOkBody.INSTANCE;
    }

    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }
}

