/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.AMQFrame;
import org.apache.qpid.server.protocol.v0_8.transport.AccessRequestBody;
import org.apache.qpid.server.protocol.v0_8.transport.AccessRequestOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicAckBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicCancelBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicCancelOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicConsumeBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicConsumeOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.BasicDeliverBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetEmptyBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicNackBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicPublishBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicQosBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicQosOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverSyncBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverSyncOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRejectBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicReturnBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelAlertBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelCloseBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelCloseOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelFlowBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelFlowOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelOpenBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelOpenOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.ClientMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.ConfirmSelectBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConfirmSelectOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionCloseBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionCloseOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionOpenBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionOpenOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionRedirectBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionSecureBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionSecureOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionStartBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionStartOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionTuneBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionTuneOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ContentBody;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeBoundBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeBoundOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeclareBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeclareOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeleteBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeleteOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.HeartbeatBody;
import org.apache.qpid.server.protocol.v0_8.transport.MethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.ProtocolInitiation;
import org.apache.qpid.server.protocol.v0_8.transport.QueueBindBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueBindOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeclareBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeclareOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeleteBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeleteOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueuePurgeBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueuePurgeOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueUnbindBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueUnbindOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.ServerMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.TxCommitBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxCommitOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxRollbackBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxRollbackOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxSelectBody;
import org.apache.qpid.server.protocol.v0_8.transport.TxSelectOkBody;

public class FrameCreatingMethodProcessor
implements MethodProcessor<ClientAndServerChannelMethodProcessor>,
ClientMethodProcessor<ClientAndServerChannelMethodProcessor>,
ServerMethodProcessor<ClientAndServerChannelMethodProcessor> {
    private ProtocolVersion _protocolVersion;
    private final List<AMQDataBlock> _processedMethods = new ArrayList<AMQDataBlock>();
    private int _classId;
    private int _methodId;

    public FrameCreatingMethodProcessor(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public List<AMQDataBlock> getProcessedMethods() {
        return this._processedMethods;
    }

    @Override
    public void receiveConnectionStart(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionStartBody(versionMajor, versionMinor, serverProperties, mechanisms, locales)));
    }

    @Override
    public void receiveConnectionStartOk(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionStartOkBody(clientProperties, mechanism, response, locale)));
    }

    @Override
    public void receiveConnectionSecure(byte[] challenge) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionSecureBody(challenge)));
    }

    @Override
    public void receiveConnectionSecureOk(byte[] response) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionSecureOkBody(response)));
    }

    @Override
    public void receiveConnectionTune(int channelMax, long frameMax, int heartbeat) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionTuneBody(channelMax, frameMax, heartbeat)));
    }

    @Override
    public void receiveConnectionTuneOk(int channelMax, long frameMax, int heartbeat) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionTuneOkBody(channelMax, frameMax, heartbeat)));
    }

    @Override
    public void receiveConnectionOpen(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionOpenBody(virtualHost, capabilities, insist)));
    }

    @Override
    public void receiveConnectionOpenOk(AMQShortString knownHosts) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionOpenOkBody(knownHosts)));
    }

    @Override
    public void receiveConnectionRedirect(AMQShortString host, AMQShortString knownHosts) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionRedirectBody(this.getProtocolVersion(), host, knownHosts)));
    }

    @Override
    public void receiveConnectionClose(int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._processedMethods.add(new AMQFrame(0, new ConnectionCloseBody(this.getProtocolVersion(), replyCode, replyText, classId, methodId)));
    }

    @Override
    public void receiveConnectionCloseOk() {
        this._processedMethods.add(new AMQFrame(0, ProtocolVersion.v0_8.equals((Object)this.getProtocolVersion()) ? ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_8 : ConnectionCloseOkBody.CONNECTION_CLOSE_OK_0_9));
    }

    @Override
    public void receiveChannelOpen(int channelId) {
        this._processedMethods.add(new AMQFrame(channelId, new ChannelOpenBody()));
    }

    private void receiveExchangeBoundOk(int channelId, int replyCode, AMQShortString replyText) {
        this._processedMethods.add(new AMQFrame(channelId, new ExchangeBoundOkBody(replyCode, replyText)));
    }

    @Override
    public void receiveHeartbeat() {
        this._processedMethods.add(new AMQFrame(0, new HeartbeatBody()));
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public ClientAndServerChannelMethodProcessor getChannelMethodProcessor(int channelId) {
        return new FrameCreatingChannelMethodProcessor(channelId);
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    @Override
    public void receiveProtocolHeader(ProtocolInitiation protocolInitiation) {
        this._processedMethods.add(protocolInitiation);
    }

    @Override
    public void setCurrentMethod(int classId, int methodId) {
        this._classId = classId;
        this._methodId = methodId;
    }

    @Override
    public boolean ignoreAllButCloseOk() {
        return false;
    }

    public int getClassId() {
        return this._classId;
    }

    public int getMethodId() {
        return this._methodId;
    }

    private class FrameCreatingChannelMethodProcessor
    implements ClientAndServerChannelMethodProcessor {
        private final int _channelId;

        private FrameCreatingChannelMethodProcessor(int channelId) {
            this._channelId = channelId;
        }

        @Override
        public void receiveChannelOpenOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, ProtocolVersion.v0_8.equals((Object)FrameCreatingMethodProcessor.this.getProtocolVersion()) ? ChannelOpenOkBody.INSTANCE_0_8 : ChannelOpenOkBody.INSTANCE_0_9));
        }

        @Override
        public void receiveChannelAlert(int replyCode, AMQShortString replyText, FieldTable details) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelAlertBody(replyCode, replyText, details)));
        }

        @Override
        public void receiveAccessRequestOk(int ticket) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new AccessRequestOkBody(ticket)));
        }

        @Override
        public void receiveExchangeDeclareOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeclareOkBody()));
        }

        @Override
        public void receiveExchangeDeleteOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeleteOkBody()));
        }

        @Override
        public void receiveExchangeBoundOk(int replyCode, AMQShortString replyText) {
            FrameCreatingMethodProcessor.this.receiveExchangeBoundOk(this._channelId, replyCode, replyText);
        }

        @Override
        public void receiveQueueBindOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueBindOkBody()));
        }

        @Override
        public void receiveQueueUnbindOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueUnbindOkBody()));
        }

        @Override
        public void receiveQueueDeclareOk(AMQShortString queue, long messageCount, long consumerCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeclareOkBody(queue, messageCount, consumerCount)));
        }

        @Override
        public void receiveQueuePurgeOk(long messageCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueuePurgeOkBody(messageCount)));
        }

        @Override
        public void receiveQueueDeleteOk(long messageCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeleteOkBody(messageCount)));
        }

        @Override
        public void receiveBasicRecoverSyncOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRecoverSyncOkBody(FrameCreatingMethodProcessor.this.getProtocolVersion())));
        }

        @Override
        public void receiveBasicQosOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicQosOkBody()));
        }

        @Override
        public void receiveBasicConsumeOk(AMQShortString consumerTag) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicConsumeOkBody(consumerTag)));
        }

        @Override
        public void receiveBasicCancelOk(AMQShortString consumerTag) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicCancelOkBody(consumerTag)));
        }

        @Override
        public void receiveBasicReturn(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicReturnBody(replyCode, replyText, exchange, routingKey)));
        }

        @Override
        public void receiveBasicDeliver(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicDeliverBody(consumerTag, deliveryTag, redelivered, exchange, routingKey)));
        }

        @Override
        public void receiveBasicGetOk(long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, long messageCount) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicGetOkBody(deliveryTag, redelivered, exchange, routingKey, messageCount)));
        }

        @Override
        public void receiveBasicGetEmpty() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicGetEmptyBody(null)));
        }

        @Override
        public void receiveTxSelectOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxSelectOkBody.INSTANCE));
        }

        @Override
        public void receiveTxCommitOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxCommitOkBody.INSTANCE));
        }

        @Override
        public void receiveTxRollbackOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxRollbackOkBody.INSTANCE));
        }

        @Override
        public void receiveConfirmSelectOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, ConfirmSelectOkBody.INSTANCE));
        }

        @Override
        public void receiveAccessRequest(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new AccessRequestBody(realm, exclusive, passive, active, write, read)));
        }

        @Override
        public void receiveExchangeDeclare(AMQShortString exchange, AMQShortString type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeclareBody(0, exchange, type, passive, durable, autoDelete, internal, nowait, arguments)));
        }

        @Override
        public void receiveExchangeDelete(AMQShortString exchange, boolean ifUnused, boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeDeleteBody(0, exchange, ifUnused, nowait)));
        }

        @Override
        public void receiveExchangeBound(AMQShortString exchange, AMQShortString routingKey, AMQShortString queue) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ExchangeBoundBody(exchange, routingKey, queue)));
        }

        @Override
        public void receiveQueueDeclare(AMQShortString queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeclareBody(0, queue, passive, durable, exclusive, autoDelete, nowait, arguments)));
        }

        @Override
        public void receiveQueueBind(AMQShortString queue, AMQShortString exchange, AMQShortString bindingKey, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueBindBody(0, queue, exchange, bindingKey, nowait, arguments)));
        }

        @Override
        public void receiveQueuePurge(AMQShortString queue, boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueuePurgeBody(0, queue, nowait)));
        }

        @Override
        public void receiveQueueDelete(AMQShortString queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueDeleteBody(0, queue, ifUnused, ifEmpty, nowait)));
        }

        @Override
        public void receiveQueueUnbind(AMQShortString queue, AMQShortString exchange, AMQShortString bindingKey, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new QueueUnbindBody(0, queue, exchange, bindingKey, arguments)));
        }

        @Override
        public void receiveBasicRecover(boolean requeue, boolean sync) {
            if (ProtocolVersion.v0_8.equals((Object)FrameCreatingMethodProcessor.this.getProtocolVersion()) || !sync) {
                FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRecoverBody(requeue)));
            } else {
                FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRecoverSyncBody(FrameCreatingMethodProcessor.this.getProtocolVersion(), requeue)));
            }
        }

        @Override
        public void receiveBasicQos(long prefetchSize, int prefetchCount, boolean global) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicQosBody(prefetchSize, prefetchCount, global)));
        }

        @Override
        public void receiveBasicConsume(AMQShortString queue, AMQShortString consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, FieldTable arguments) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicConsumeBody(0, queue, consumerTag, noLocal, noAck, exclusive, nowait, arguments)));
        }

        @Override
        public void receiveBasicCancel(AMQShortString consumerTag, boolean noWait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicCancelBody(consumerTag, noWait)));
        }

        @Override
        public void receiveBasicPublish(AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicPublishBody(0, exchange, routingKey, mandatory, immediate)));
        }

        @Override
        public void receiveBasicGet(AMQShortString queue, boolean noAck) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicGetBody(0, queue, noAck)));
        }

        @Override
        public void receiveBasicAck(long deliveryTag, boolean multiple) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicAckBody(deliveryTag, multiple)));
        }

        @Override
        public void receiveBasicReject(long deliveryTag, boolean requeue) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicRejectBody(deliveryTag, requeue)));
        }

        @Override
        public void receiveTxSelect() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxSelectBody.INSTANCE));
        }

        @Override
        public void receiveTxCommit() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxCommitBody.INSTANCE));
        }

        @Override
        public void receiveTxRollback() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, TxRollbackBody.INSTANCE));
        }

        @Override
        public void receiveConfirmSelect(boolean nowait) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ConfirmSelectBody(nowait)));
        }

        @Override
        public void receiveChannelFlow(boolean active) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelFlowBody(active)));
        }

        @Override
        public void receiveChannelFlowOk(boolean active) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelFlowOkBody(active)));
        }

        @Override
        public void receiveChannelClose(int replyCode, AMQShortString replyText, int classId, int methodId) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ChannelCloseBody(replyCode, replyText, classId, methodId)));
        }

        @Override
        public void receiveChannelCloseOk() {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, ChannelCloseOkBody.INSTANCE));
        }

        @Override
        public void receiveMessageContent(QpidByteBuffer data) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ContentBody(data)));
        }

        @Override
        public void receiveMessageHeader(BasicContentHeaderProperties properties, long bodySize) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new ContentHeaderBody(properties, bodySize)));
        }

        @Override
        public boolean ignoreAllButCloseOk() {
            return false;
        }

        @Override
        public void receiveBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
            FrameCreatingMethodProcessor.this._processedMethods.add(new AMQFrame(this._channelId, new BasicNackBody(deliveryTag, multiple, requeue)));
        }
    }

    public static interface ClientAndServerChannelMethodProcessor
    extends ServerChannelMethodProcessor,
    ClientChannelMethodProcessor {
    }
}

