/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.qpid.QpidException;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MessagePublishInfo;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQPConnection_0_8;
import org.apache.qpid.server.protocol.v0_8.ProtocolOutputConverter;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final int BASIC_CLASS_ID = 60;
    private final AMQPConnection_0_8 _connection;
    private static final AMQShortString GZIP_ENCODING = AMQShortString.valueOf((String)"gzip");
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolOutputConverterImpl.class);

    public ProtocolOutputConverterImpl(AMQPConnection_0_8 connection) {
        this._connection = connection;
    }

    @Override
    public long writeDeliver(ServerMessage m, InstanceProperties props, int channelId, long deliveryTag, AMQShortString consumerTag) {
        AMQMessage msg = this.convertToAMQMessage(m);
        boolean isRedelivered = Boolean.TRUE.equals(props.getProperty(InstanceProperties.Property.REDELIVERED));
        AMQBody deliverBody = this.createEncodedDeliverBody(msg, isRedelivered, deliveryTag, consumerTag);
        return this.writeMessageDelivery(msg, channelId, deliverBody);
    }

    private AMQMessage convertToAMQMessage(ServerMessage serverMessage) {
        if (serverMessage instanceof AMQMessage) {
            return (AMQMessage)serverMessage;
        }
        return (AMQMessage)this.getMessageConverter(serverMessage).convert(serverMessage, (VirtualHostImpl)this._connection.getVirtualHost());
    }

    private <M extends ServerMessage> MessageConverter<M, AMQMessage> getMessageConverter(M message) {
        Class<?> clazz = message.getClass();
        return MessageConverterRegistry.getConverter(clazz, AMQMessage.class);
    }

    private long writeMessageDelivery(AMQMessage message, int channelId, AMQBody deliverBody) {
        return this.writeMessageDelivery((MessageContentSource)message, message.getContentHeaderBody(), channelId, deliverBody);
    }

    private long writeMessageDelivery(MessageContentSource message, ContentHeaderBody contentHeaderBody, int channelId, AMQBody deliverBody) {
        long length;
        BasicContentHeaderProperties modifiedProps;
        int bodySize = (int)message.getSize();
        boolean msgCompressed = this.isCompressed(contentHeaderBody);
        Collection<QpidByteBuffer> modifiedContentBuffers = null;
        boolean compressionSupported = this._connection.isCompressionSupported();
        Collection contentBuffers = message.getContent();
        if (msgCompressed && !compressionSupported && contentBuffers != null && (modifiedContentBuffers = this.inflateIfPossible(contentBuffers)) != null) {
            modifiedProps = new BasicContentHeaderProperties(contentHeaderBody.getProperties());
            modifiedProps.setEncoding((String)null);
            length = this.writeMessageDeliveryModified(modifiedContentBuffers, channelId, deliverBody, modifiedProps);
        } else if (!msgCompressed && compressionSupported && contentHeaderBody.getProperties().getEncoding() == null && bodySize > this._connection.getMessageCompressionThreshold() && contentBuffers != null && (modifiedContentBuffers = this.deflateIfPossible(contentBuffers)) != null) {
            modifiedProps = new BasicContentHeaderProperties(contentHeaderBody.getProperties());
            modifiedProps.setEncoding(GZIP_ENCODING);
            length = this.writeMessageDeliveryModified(modifiedContentBuffers, channelId, deliverBody, modifiedProps);
        } else {
            this.writeMessageDeliveryUnchanged(contentBuffers, channelId, deliverBody, contentHeaderBody, bodySize);
            length = bodySize;
        }
        if (contentBuffers != null) {
            for (QpidByteBuffer buf : contentBuffers) {
                buf.dispose();
            }
        }
        if (modifiedContentBuffers != null) {
            for (QpidByteBuffer buf : modifiedContentBuffers) {
                buf.dispose();
            }
        }
        return length;
    }

    private Collection<QpidByteBuffer> deflateIfPossible(Collection<QpidByteBuffer> buffers) {
        try {
            return QpidByteBuffer.deflate(buffers);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to compress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            return null;
        }
    }

    private Collection<QpidByteBuffer> inflateIfPossible(Collection<QpidByteBuffer> buffers) {
        try {
            return QpidByteBuffer.inflate(buffers);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to decompress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            return null;
        }
    }

    private int writeMessageDeliveryModified(Collection<QpidByteBuffer> contentBuffers, int channelId, AMQBody deliverBody, BasicContentHeaderProperties modifiedProps) {
        int bodySize = ByteBufferUtils.remaining(contentBuffers);
        ContentHeaderBody modifiedHeaderBody = new ContentHeaderBody(modifiedProps, (long)bodySize);
        this.writeMessageDeliveryUnchanged(contentBuffers, channelId, deliverBody, modifiedHeaderBody, bodySize);
        return bodySize;
    }

    private void writeMessageDeliveryUnchanged(Collection<QpidByteBuffer> contentBuffers, int channelId, AMQBody deliverBody, ContentHeaderBody contentHeaderBody, int bodySize) {
        if (bodySize == 0) {
            SmallCompositeAMQBodyBlock compositeBlock = new SmallCompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody);
            this.writeFrame(compositeBlock);
        } else {
            int capacity;
            MessageContentSourceBody firstContentBody = new MessageContentSourceBody(contentBuffers, 0, capacity);
            CompositeAMQBodyBlock compositeBlock = new CompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody, firstContentBody);
            this.writeFrame(compositeBlock);
            for (int writtenSize = capacity = bodySize > (maxBodySize = (int)this._connection.getMaxFrameSize() - AMQFrame.getFrameOverhead()) ? maxBodySize : bodySize; writtenSize < bodySize; writtenSize += capacity) {
                int maxBodySize;
                capacity = bodySize - writtenSize > maxBodySize ? maxBodySize : bodySize - writtenSize;
                MessageContentSourceBody body = new MessageContentSourceBody(contentBuffers, writtenSize, capacity);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, (AMQBody)body));
            }
        }
    }

    private boolean isCompressed(ContentHeaderBody contentHeaderBody) {
        return GZIP_ENCODING.equals(contentHeaderBody.getProperties().getEncoding());
    }

    @Override
    public long writeGetOk(ServerMessage msg, InstanceProperties props, int channelId, long deliveryTag, int queueSize) {
        AMQBody deliver = this.createEncodedGetOkBody(msg, props, deliveryTag, queueSize);
        return this.writeMessageDelivery(this.convertToAMQMessage(msg), channelId, deliver);
    }

    private AMQBody createEncodedDeliverBody(AMQMessage message, boolean isRedelivered, long deliveryTag, AMQShortString consumerTag) {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        EncodedDeliveryBody returnBlock = new EncodedDeliveryBody(deliveryTag, routingKey, exchangeName, consumerTag, isRedelivered);
        return returnBlock;
    }

    private AMQBody createEncodedGetOkBody(ServerMessage msg, InstanceProperties props, long deliveryTag, int queueSize) {
        AMQMessage message = this.convertToAMQMessage(msg);
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        boolean isRedelivered = Boolean.TRUE.equals(props.getProperty(InstanceProperties.Property.REDELIVERED));
        BasicGetOkBody getOkBody = this._connection.getMethodRegistry().createBasicGetOkBody(deliveryTag, isRedelivered, exchangeName, routingKey, (long)queueSize);
        return getOkBody;
    }

    private AMQBody createEncodedReturnFrame(MessagePublishInfo messagePublishInfo, int replyCode, AMQShortString replyText) {
        BasicReturnBody basicReturnBody = this._connection.getMethodRegistry().createBasicReturnBody(replyCode, replyText, messagePublishInfo.getExchange(), messagePublishInfo.getRoutingKey());
        return basicReturnBody;
    }

    @Override
    public void writeReturn(MessagePublishInfo messagePublishInfo, ContentHeaderBody header, MessageContentSource message, int channelId, int replyCode, AMQShortString replyText) {
        AMQBody returnFrame = this.createEncodedReturnFrame(messagePublishInfo, replyCode, replyText);
        this.writeMessageDelivery(message, header, channelId, returnFrame);
    }

    @Override
    public void writeFrame(AMQDataBlock block) {
        this._connection.writeFrame(block);
    }

    @Override
    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = this._connection.getMethodRegistry().createBasicCancelOkBody(consumerTag);
        this.writeFrame((AMQDataBlock)basicCancelOkBody.generateFrame(channelId));
    }

    public static final class SmallCompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 2 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final int _channel;

        public SmallCompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize();
        }

        public void writePayload(DataOutput buffer) throws IOException {
            AMQFrame.writeFrames((DataOutput)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody);
        }

        public long writePayload(ByteBufferSender sender) throws IOException {
            long size = new AMQFrame(this._channel, this._methodBody).writePayload(sender);
            return size += new AMQFrame(this._channel, this._headerBody).writePayload(sender);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(((Object)((Object)this)).getClass().getSimpleName()).append("methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    public static final class CompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 3 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final AMQBody _contentBody;
        private final int _channel;

        public CompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody, AMQBody contentBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
            this._contentBody = contentBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize() + this._contentBody.getSize();
        }

        public void writePayload(DataOutput buffer) throws IOException {
            AMQFrame.writeFrames((DataOutput)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody, (AMQBody)this._contentBody);
        }

        public long writePayload(ByteBufferSender sender) throws IOException {
            long size = new AMQFrame(this._channel, this._methodBody).writePayload(sender);
            size += new AMQFrame(this._channel, this._headerBody).writePayload(sender);
            return size += new AMQFrame(this._channel, this._contentBody).writePayload(sender);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(((Object)((Object)this)).getClass().getSimpleName()).append(" methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", contentBody=").append(this._contentBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    private class EncodedDeliveryBody
    implements AMQBody {
        private final long _deliveryTag;
        private final AMQShortString _routingKey;
        private final AMQShortString _exchangeName;
        private final AMQShortString _consumerTag;
        private final boolean _isRedelivered;
        private AMQBody _underlyingBody;

        private EncodedDeliveryBody(long deliveryTag, AMQShortString routingKey, AMQShortString exchangeName, AMQShortString consumerTag, boolean isRedelivered) {
            this._deliveryTag = deliveryTag;
            this._routingKey = routingKey;
            this._exchangeName = exchangeName;
            this._consumerTag = consumerTag;
            this._isRedelivered = isRedelivered;
        }

        public AMQBody createAMQBody() {
            return ProtocolOutputConverterImpl.this._connection.getMethodRegistry().createBasicDeliverBody(this._consumerTag, this._deliveryTag, this._isRedelivered, this._exchangeName, this._routingKey);
        }

        public byte getFrameType() {
            return 1;
        }

        public int getSize() {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.getSize();
        }

        public void writePayload(DataOutput buffer) throws IOException {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            this._underlyingBody.writePayload(buffer);
        }

        public long writePayload(ByteBufferSender sender) throws IOException {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.writePayload(sender);
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws QpidException {
            throw new QpidException("This block should never be dispatched!");
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " underlyingBody: " + String.valueOf(this._underlyingBody) + "]";
        }
    }

    private class MessageContentSourceBody
    implements AMQBody {
        public static final byte TYPE = 3;
        private final int _length;
        private final Collection<QpidByteBuffer> _contentBuffers;
        private final int _offset;

        public MessageContentSourceBody(Collection<QpidByteBuffer> bufs, int offset, int length) {
            int pos = 0;
            int added = 0;
            ArrayList<QpidByteBuffer> content = new ArrayList<QpidByteBuffer>(bufs.size());
            for (QpidByteBuffer buf : bufs) {
                if (pos < offset) {
                    int remaining = buf.remaining();
                    if (pos + remaining > offset) {
                        buf = buf.view(offset - pos, length);
                        content.add(buf);
                        added += buf.remaining();
                    }
                    pos += remaining;
                } else {
                    if ((buf = buf.slice()).remaining() > length - added) {
                        buf.limit(length - added);
                    }
                    content.add(buf);
                    added += buf.remaining();
                }
                if (added < length) continue;
                break;
            }
            this._contentBuffers = content;
            this._offset = offset;
            this._length = length;
        }

        public byte getFrameType() {
            return 3;
        }

        public int getSize() {
            return this._length;
        }

        public void writePayload(DataOutput buffer) throws IOException {
            for (QpidByteBuffer buf : this._contentBuffers) {
                if (buf.hasArray()) {
                    buffer.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                } else {
                    byte[] data = new byte[this._length];
                    buf.get(data);
                    buffer.write(data);
                }
                buf.dispose();
            }
        }

        public long writePayload(ByteBufferSender sender) throws IOException {
            long size = 0L;
            for (QpidByteBuffer buf : this._contentBuffers) {
                size += (long)buf.remaining();
                sender.send(buf);
                buf.dispose();
            }
            return size;
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws QpidException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " offset: " + this._offset + ", length: " + this._length + "]";
        }
    }
}

