/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.transport.ProtocolEngine;

public class Pre0_10CreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private final ProtocolEngine _protocolEngine;
    private volatile long _bytesCreditLimit;
    private volatile long _messageCreditLimit;
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    public Pre0_10CreditManager(long bytesCreditLimit, long messageCreditLimit, ProtocolEngine protocolEngine) {
        this._protocolEngine = protocolEngine;
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this._bytesCredit = bytesCreditLimit;
        this._messageCredit = messageCreditLimit;
    }

    public synchronized void setCreditLimits(long bytesCreditLimit, long messageCreditLimit) {
        long bytesCreditChange = bytesCreditLimit - this._bytesCreditLimit;
        long messageCreditChange = messageCreditLimit - this._messageCreditLimit;
        if (bytesCreditChange != 0L) {
            this._bytesCredit = bytesCreditLimit == 0L ? 0L : (this._bytesCredit += bytesCreditChange);
        }
        if (messageCreditChange != 0L) {
            this._messageCredit = messageCreditLimit == 0L ? 0L : (this._messageCredit += messageCreditChange);
        }
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        long bytesCreditLimit;
        long messageCreditLimit = this._messageCreditLimit;
        boolean notifyIncrease = true;
        if (messageCreditLimit != 0L) {
            notifyIncrease = this._messageCredit != 0L;
            long newCredit = this._messageCredit + messageCredit;
            long l = this._messageCredit = newCredit > messageCreditLimit ? messageCreditLimit : newCredit;
        }
        if ((bytesCreditLimit = this._bytesCreditLimit) != 0L) {
            long newCredit = this._bytesCredit + bytesCredit;
            this._bytesCredit = newCredit > bytesCreditLimit ? bytesCreditLimit : newCredit;
            notifyIncrease = notifyIncrease && bytesCredit > 0L;
        } else {
            notifyIncrease = false;
        }
        if (!this.setSuspended(!this.hasCredit()) && notifyIncrease) {
            this.notifyIncreaseBytesCredit();
        }
    }

    public synchronized boolean hasCredit() {
        return !(this._bytesCreditLimit != 0L && this._bytesCredit <= 0L || this._messageCreditLimit != 0L && this._messageCredit <= 0L || this._protocolEngine.isTransportBlockedForWriting());
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._protocolEngine.isTransportBlockedForWriting()) {
            this.setSuspended(true);
            return false;
        }
        if (this._messageCreditLimit != 0L) {
            if (this._messageCredit > 0L) {
                if (this._bytesCreditLimit == 0L) {
                    --this._messageCredit;
                    return true;
                }
                if (this._bytesCredit >= msgSize || this._bytesCredit == this._bytesCreditLimit) {
                    --this._messageCredit;
                    this._bytesCredit -= msgSize;
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCreditLimit == 0L) {
            return true;
        }
        if (this._bytesCredit >= msgSize || this._bytesCredit == this._bytesCreditLimit) {
            this._bytesCredit -= msgSize;
            return true;
        }
        return false;
    }
}

