/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;

public class MessageOnlyCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private final AtomicLong _messageCredit;

    public MessageOnlyCreditManager(long initialCredit) {
        this._messageCredit = new AtomicLong(initialCredit);
    }

    public void restoreCredit(long messageCredit, long bytesCredit) {
        this._messageCredit.addAndGet(messageCredit);
        this.setSuspended(false);
    }

    public boolean hasCredit() {
        return this._messageCredit.get() > 0L;
    }

    public boolean useCreditForMessage(long msgSize) {
        if (this.hasCredit()) {
            if (this._messageCredit.addAndGet(-1L) >= 0L) {
                this.setSuspended(false);
                return true;
            }
            this._messageCredit.addAndGet(1L);
            this.setSuspended(true);
            return false;
        }
        this.setSuspended(true);
        return false;
    }
}

