/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.codec.ServerDecoder;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.ServerMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQPConnection_0_8;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerDecoder
extends ServerDecoder {
    private static final Logger _logger = LoggerFactory.getLogger(BrokerDecoder.class);
    private final AMQPConnection_0_8 _connection;

    public BrokerDecoder(AMQPConnection_0_8 connection) {
        super((ServerMethodProcessor)connection);
        this._connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFrame(final int channelId, final byte type, final long bodySize, final MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        block11: {
            long startTime = 0L;
            try {
                AMQChannel channel;
                if (_logger.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                if ((channel = this._connection.getChannel(channelId)) == null) {
                    this.doProcessFrame(channelId, type, bodySize, in);
                    break block11;
                }
                this._connection.channelRequiresSync(channel);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Void run() throws IOException, AMQFrameDecodingException {
                            BrokerDecoder.this.doProcessFrame(channelId, type, bodySize, in);
                            return null;
                        }
                    }, channel.getAccessControllerContext());
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof AMQFrameDecodingException) {
                        throw (AMQFrameDecodingException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new ServerScopedRuntimeException(cause);
                }
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Frame handled in {} ms.", (Object)(System.currentTimeMillis() - startTime));
                }
            }
        }
    }

    private void doProcessFrame(int channelId, byte type, long bodySize, MarkableDataInput in) throws AMQFrameDecodingException, IOException {
        super.processFrame(channelId, type, bodySize, in);
    }
}

