/*
*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*
*/
package org.apache.qpid.server.protocol.v0_8;

import java.util.concurrent.atomic.AtomicLong;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;

public class MessageOnlyCreditManager extends AbstractFlowCreditManager implements FlowCreditManager
{
    private final AtomicLong _messageCredit;

    public MessageOnlyCreditManager(final long initialCredit)
    {
        _messageCredit = new AtomicLong(initialCredit);
    }

    public void restoreCredit(long messageCredit, long bytesCredit)
    {
        _messageCredit.addAndGet(messageCredit);
        setSuspended(false);

    }

    public boolean hasCredit()
    {
        return _messageCredit.get() > 0L;
    }

    public boolean useCreditForMessage(long msgSize)
    {
        if(hasCredit())
        {
            if(_messageCredit.addAndGet(-1L) >= 0)
            {
                setSuspended(false);
                return true;
            }
            else
            {
                _messageCredit.addAndGet(1L);
                setSuspended(true);
                return false;
            }
        }
        else
        {
            setSuspended(true);
            return false;
        }
                
    }

}
