/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.transport.AbstractEncoder;

public final class ServerEncoder
extends AbstractEncoder {
    public static final int DEFAULT_CAPACITY = 262144;
    private final boolean _useDirectMemory;
    private final int _threshold;
    private QpidByteBuffer _out;
    private int _initialCapacity;

    public ServerEncoder() {
        this(QpidByteBuffer.getPooledBufferSize(), true);
    }

    public ServerEncoder(int capacity, boolean useDirectMemory) {
        this._useDirectMemory = useDirectMemory;
        this._initialCapacity = capacity > 0 ? capacity : 262144;
        this._threshold = Math.min(this._initialCapacity / 16, 256);
        this._out = QpidByteBuffer.allocate((boolean)useDirectMemory, (int)this._initialCapacity);
    }

    @Override
    public void init() {
        if (this._out.capacity() < this._threshold) {
            this._out.dispose();
            this._out = QpidByteBuffer.allocate((boolean)this._useDirectMemory, (int)this._initialCapacity);
        } else {
            this._out.clear();
        }
    }

    public QpidByteBuffer getBuffer() {
        int pos = this._out.position();
        this._out.position(0);
        QpidByteBuffer slice = this._out.view(0, pos);
        QpidByteBuffer old = this._out;
        this._out.position(pos);
        this._out = this._out.slice();
        old.dispose();
        return slice;
    }

    @Override
    public int position() {
        return this._out.position();
    }

    private void grow(int size) {
        QpidByteBuffer old = this._out;
        int capacity = old.capacity();
        this._out = QpidByteBuffer.allocate((boolean)this._useDirectMemory, (int)Math.max(Math.max(capacity + size, 2 * capacity), this._initialCapacity));
        old.flip();
        this._out.put(old);
        old.dispose();
    }

    @Override
    protected void doPut(byte b) {
        try {
            this._out.put(b);
        }
        catch (BufferOverflowException e) {
            this.grow(1);
            this._out.put(b);
        }
    }

    @Override
    protected void doPut(ByteBuffer src) {
        try {
            this._out.put(src);
        }
        catch (BufferOverflowException e) {
            this.grow(src.remaining());
            this._out.put(src);
        }
    }

    @Override
    protected void put(byte[] bytes) {
        try {
            this._out.put(bytes);
        }
        catch (BufferOverflowException e) {
            this.grow(bytes.length);
            this._out.put(bytes);
        }
    }

    @Override
    public void writeUint8(short b) {
        assert (b < 256);
        try {
            this._out.put((byte)b);
        }
        catch (BufferOverflowException e) {
            this.grow(1);
            this._out.put((byte)b);
        }
    }

    @Override
    public void writeUint16(int s) {
        assert (s < 65536);
        try {
            this._out.putShort((short)s);
        }
        catch (BufferOverflowException e) {
            this.grow(2);
            this._out.putShort((short)s);
        }
    }

    @Override
    public void writeUint32(long i) {
        assert (i < 0x100000000L);
        try {
            this._out.putInt((int)i);
        }
        catch (BufferOverflowException e) {
            this.grow(4);
            this._out.putInt((int)i);
        }
    }

    @Override
    public void writeUint64(long l) {
        try {
            this._out.putLong(l);
        }
        catch (BufferOverflowException e) {
            this.grow(8);
            this._out.putLong(l);
        }
    }

    @Override
    public int beginSize8() {
        int pos = this._out.position();
        try {
            this._out.put((byte)0);
        }
        catch (BufferOverflowException e) {
            this.grow(1);
            this._out.put((byte)0);
        }
        return pos;
    }

    @Override
    public void endSize8(int pos) {
        int cur = this._out.position();
        this._out.put(pos, (byte)(cur - pos - 1));
    }

    @Override
    public int beginSize16() {
        int pos = this._out.position();
        try {
            this._out.putShort((short)0);
        }
        catch (BufferOverflowException e) {
            this.grow(2);
            this._out.putShort((short)0);
        }
        return pos;
    }

    @Override
    public void endSize16(int pos) {
        int cur = this._out.position();
        this._out.putShort(pos, (short)(cur - pos - 2));
    }

    @Override
    public int beginSize32() {
        int pos = this._out.position();
        try {
            this._out.putInt(0);
        }
        catch (BufferOverflowException e) {
            this.grow(4);
            this._out.putInt(0);
        }
        return pos;
    }

    @Override
    public void endSize32(int pos) {
        int cur = this._out.position();
        this._out.putInt(pos, cur - pos - 4);
    }

    @Override
    public void writeDouble(double aDouble) {
        try {
            this._out.putDouble(aDouble);
        }
        catch (BufferOverflowException exception) {
            this.grow(8);
            this._out.putDouble(aDouble);
        }
    }

    @Override
    public void writeInt16(short aShort) {
        try {
            this._out.putShort(aShort);
        }
        catch (BufferOverflowException exception) {
            this.grow(2);
            this._out.putShort(aShort);
        }
    }

    @Override
    public void writeInt32(int anInt) {
        try {
            this._out.putInt(anInt);
        }
        catch (BufferOverflowException exception) {
            this.grow(4);
            this._out.putInt(anInt);
        }
    }

    @Override
    public void writeInt64(long aLong) {
        try {
            this._out.putLong(aLong);
        }
        catch (BufferOverflowException exception) {
            this.grow(8);
            this._out.putLong(aLong);
        }
    }

    @Override
    public void writeInt8(byte aByte) {
        try {
            this._out.put(aByte);
        }
        catch (BufferOverflowException exception) {
            this.grow(1);
            this._out.put(aByte);
        }
    }

    @Override
    public void writeBin128(byte[] byteArray) {
        byte[] byArray = byteArray = byteArray != null ? byteArray : new byte[16];
        assert (byteArray.length == 16);
        try {
            this._out.put(byteArray);
        }
        catch (BufferOverflowException exception) {
            this.grow(16);
            this._out.put(byteArray);
        }
    }

    public void writeBin128(UUID id) {
        int i;
        byte[] data = new byte[16];
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        assert (data.length == 16);
        for (i = 7; i >= 0; --i) {
            data[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            data[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        this.writeBin128(data);
    }

    @Override
    public void writeFloat(float aFloat) {
        try {
            this._out.putFloat(aFloat);
        }
        catch (BufferOverflowException exception) {
            this.grow(4);
            this._out.putFloat(aFloat);
        }
    }

    public void close() {
        this._out.dispose();
    }
}

