/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.charset.StandardCharsets;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryPriority;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_v0_10
implements MessageConverter<ServerMessage, MessageTransferMessage> {
    public Class<ServerMessage> getInputClass() {
        return ServerMessage.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(ServerMessage serverMsg, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg), null);
    }

    public void dispose(MessageTransferMessage message) {
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final ServerMessage<?> serverMsg) {
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg);
        final int metadataSize = messageMetaData_0_10.getStorableSize();
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public QpidByteBuffer getContent(int offset, int length) {
                return serverMsg.getContent(offset, length);
            }

            public int getContentSize() {
                return messageMetaData_0_10.getContentSize();
            }

            public int getMetadataSize() {
                return metadataSize;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }

            public void reallocate() {
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(ServerMessage serverMsg) {
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        int size = (int)serverMsg.getSize();
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setPriority(MessageDeliveryPriority.get(serverMsg.getMessageHeader().getPriority()));
        deliveryProps.setRoutingKey(serverMsg.getInitialRoutingAddress());
        deliveryProps.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        messageProps.setContentEncoding(serverMsg.getMessageHeader().getEncoding());
        messageProps.setContentLength(size);
        messageProps.setContentType(serverMsg.getMessageHeader().getMimeType());
        if (serverMsg.getMessageHeader().getCorrelationId() != null) {
            messageProps.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId().getBytes(StandardCharsets.UTF_8));
        }
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "Unknown to v0-10";
    }
}

