/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentConverterRegistry;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.EncoderUtils;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryPriority;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.ReplyTo;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_Internal_to_v0_10
implements MessageConverter<InternalMessage, MessageTransferMessage> {
    private static final int MAX_VBIN16_LENGTH = 65535;
    private static final int MAX_STR8_LENGTH = 255;

    public Class<InternalMessage> getInputClass() {
        return InternalMessage.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg, addressSpace), null);
    }

    public void dispose(MessageTransferMessage message) {
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        Object messageBody = serverMsg.getMessageBody();
        ObjectToMimeContentConverter converter = MimeContentConverterRegistry.getBestFitObjectToMimeContentConverter((Object)messageBody);
        final byte[] messageContent = converter == null ? new byte[]{} : converter.toMimeContent(messageBody);
        String mimeType = converter == null ? null : converter.getMimeType();
        mimeType = this.improveMimeType(serverMsg, mimeType);
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg, addressSpace, mimeType, messageContent.length);
        final int metadataSize = messageMetaData_0_10.getStorableSize();
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public QpidByteBuffer getContent(int offset, int length) {
                return QpidByteBuffer.wrap((byte[])messageContent, (int)offset, (int)length);
            }

            public int getContentSize() {
                return messageContent.length;
            }

            public int getMetadataSize() {
                return metadataSize;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }

            public void reallocate() {
            }
        };
    }

    private String improveMimeType(InternalMessage serverMsg, String mimeType) {
        if (serverMsg.getMessageHeader() != null && serverMsg.getMessageHeader().getMimeType() != null) {
            if ("text/plain".equals(mimeType) && serverMsg.getMessageHeader().getMimeType().startsWith("text/")) {
                mimeType = serverMsg.getMessageHeader().getMimeType();
            } else if ("application/octet-stream".equals(mimeType)) {
                mimeType = serverMsg.getMessageHeader().getMimeType();
            }
        }
        return mimeType;
    }

    private MessageMetaData_0_10 convertMetaData(InternalMessage serverMsg, NamedAddressSpace addressSpace, String bodyMimeType, int size) {
        String origReplyTo;
        byte[] bytes;
        String userId;
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        deliveryProps.setDeliveryMode(serverMsg.isPersistent() ? MessageDeliveryMode.PERSISTENT : MessageDeliveryMode.NON_PERSISTENT);
        long expiration = serverMsg.getExpiration();
        if (expiration > 0L) {
            deliveryProps.setExpiration(expiration);
            deliveryProps.setTtl(Math.max(0L, expiration - serverMsg.getArrivalTime()));
        }
        InternalMessageHeader messageHeader = serverMsg.getMessageHeader();
        deliveryProps.setPriority(MessageDeliveryPriority.get(messageHeader.getPriority()));
        this.convertToAndInitialRoutingKey(serverMsg, deliveryProps, addressSpace);
        deliveryProps.setTimestamp(messageHeader.getTimestamp());
        messageProps.setContentEncoding(this.ensureStr8("content-encoding", messageHeader.getEncoding()));
        messageProps.setContentLength(size);
        messageProps.setContentType(bodyMimeType);
        if (messageHeader.getCorrelationId() != null) {
            messageProps.setCorrelationId(this.ensureVBin16("correlation-id", messageHeader.getCorrelationId().getBytes(StandardCharsets.UTF_8)));
        }
        this.validateValue(messageHeader.getHeaderMap(), "application-headers");
        messageProps.setApplicationHeaders(messageHeader.getHeaderMap());
        String messageIdAsString = messageHeader.getMessageId();
        if (messageIdAsString != null) {
            try {
                if (messageIdAsString.startsWith("ID:")) {
                    messageIdAsString = messageIdAsString.substring(3);
                }
                messageProps.setMessageId(UUID.fromString(messageIdAsString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((userId = messageHeader.getUserId()) != null && (bytes = userId.getBytes(StandardCharsets.UTF_8)).length <= 65535) {
            messageProps.setUserId(bytes);
        }
        if ((origReplyTo = messageHeader.getReplyTo()) != null && !origReplyTo.equals("")) {
            messageProps.setReplyTo(this.getReplyTo(addressSpace, origReplyTo));
        }
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    private void convertToAndInitialRoutingKey(InternalMessage serverMsg, DeliveryProperties deliveryProps, NamedAddressSpace addressSpace) {
        String routingKey;
        String exchangeName;
        String to = serverMsg.getTo();
        if (to == null || "".equals(to)) {
            to = serverMsg.getInitialRoutingAddress();
        }
        if (to != null && !"".equals(to)) {
            DestinationAddress destinationAddress = new DestinationAddress(addressSpace, to);
            MessageDestination messageDestination = destinationAddress.getMessageDestination();
            if (messageDestination instanceof Queue) {
                exchangeName = "";
                routingKey = messageDestination.getName();
            } else if (messageDestination instanceof Exchange) {
                exchangeName = messageDestination.getName();
                routingKey = destinationAddress.getRoutingKey();
            } else {
                exchangeName = "";
                routingKey = to;
            }
        } else {
            exchangeName = "";
            routingKey = "";
        }
        deliveryProps.setRoutingKey(this.ensureStr8("to' or 'initialRoutingAddress", routingKey));
        deliveryProps.setExchange(this.ensureStr8("to' or 'initialRoutingAddress", exchangeName));
    }

    private ReplyTo getReplyTo(NamedAddressSpace addressSpace, String origReplyTo) {
        DestinationAddress destinationAddress = new DestinationAddress(addressSpace, origReplyTo);
        MessageDestination messageDestination = destinationAddress.getMessageDestination();
        String exchange = this.ensureStr8("reply-to[\"exchange\"]", messageDestination instanceof Exchange ? messageDestination.getName() : "");
        String routingKey = this.ensureStr8("reply-to[\"routing-key\"]", messageDestination instanceof Queue ? messageDestination.getName() : destinationAddress.getRoutingKey());
        return new ReplyTo(exchange, routingKey);
    }

    private void validateValue(Object value, String path) {
        if (!EncoderUtils.isEncodable(value)) {
            throw new MessageConversionException(String.format("Could not convert message from internal to 0-10 because conversion of %s failed. Unsupported type is used.", path));
        }
    }

    public String getType() {
        return "Internal to v0-10";
    }

    private byte[] ensureVBin16(String propertyName, byte[] result) {
        if (result != null && result.length > 65535) {
            throw new MessageConversionException(String.format("Could not convert message from internal to 0-10 because conversion of '%s' failed. The array length exceeds allowed maximum.", propertyName));
        }
        return result;
    }

    private String ensureStr8(String propertyName, String string) {
        if (string != null && string.length() > 255) {
            throw new MessageConversionException(String.format("Could not convert message from internal to 0-10 because conversion of '%s' failed. The string length exceeds allowed maximum.", propertyName));
        }
        return string;
    }
}

