/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;

public class CreditCreditManager
implements FlowCreditManager_0_10 {
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    public CreditCreditManager(long bytesCredit, long messageCredit) {
        this._bytesCredit = bytesCredit;
        this._messageCredit = messageCredit;
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
    }

    @Override
    public synchronized void addCredit(long messageCredit, long bytesCredit) {
        if (this._messageCredit >= 0L && messageCredit > 0L) {
            this._messageCredit += messageCredit;
        }
        if (this._bytesCredit >= 0L && bytesCredit > 0L) {
            this._bytesCredit += bytesCredit;
        }
    }

    @Override
    public synchronized void clearCredit() {
        this._bytesCredit = 0L;
        this._messageCredit = 0L;
    }

    public synchronized boolean hasCredit() {
        return this._bytesCredit != 0L && this._messageCredit != 0L;
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._messageCredit >= 0L) {
            if (this._messageCredit > 0L) {
                if (this._bytesCredit < 0L) {
                    --this._messageCredit;
                    return true;
                }
                if (msgSize <= this._bytesCredit) {
                    --this._messageCredit;
                    this._bytesCredit -= msgSize;
                    return true;
                }
                return false;
            }
            return false;
        }
        if (this._bytesCredit >= 0L) {
            if (msgSize <= this._bytesCredit) {
                this._bytesCredit -= msgSize;
                return true;
            }
            return false;
        }
        return true;
    }
}

