/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RuleCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleCollector.class);
    private static final Integer INCREMENT = 10;
    private final NavigableMap<Integer, Rule> _rules = new TreeMap<Integer, Rule>();
    private final Map<RuleKey, Integer> _ruleSet = new HashMap<RuleKey, Integer>();
    private Result _defaultResult = Result.DENIED;

    RuleCollector() {
    }

    public boolean isValidNumber(Integer number) {
        return !this._rules.containsKey(number);
    }

    public void addRule(Integer position, Rule rule) {
        RuleKey key;
        if (position == null) {
            position = this._rules.isEmpty() ? Integer.valueOf(0) : Integer.valueOf((Integer)this._rules.lastKey() + INCREMENT);
        }
        if (this._ruleSet.containsKey(key = new RuleKey(rule))) {
            LOGGER.warn("Duplicate rule for the '{}'", (Object)key);
            Integer previousPosition = this._ruleSet.get(key);
            if (previousPosition > position) {
                this._ruleSet.remove(key);
                this._rules.remove(previousPosition);
            } else {
                return;
            }
        }
        this._rules.put(position, rule);
        this._ruleSet.put(key, position);
    }

    void setDefaultResult(Result defaultResult) {
        this._defaultResult = defaultResult;
    }

    RuleSet createRuleSet(EventLoggerProvider eventLoggerProvider) {
        return RuleSet.newInstance(eventLoggerProvider, this._rules.values(), this._defaultResult);
    }

    private static final class RuleKey {
        private final String _identity;
        private final LegacyOperation _operation;
        private final ObjectType _object;
        private final AclRulePredicates _predicates;

        RuleKey(Rule rule) {
            this._identity = rule.getIdentity();
            this._operation = rule.getOperation();
            this._object = rule.getObjectType();
            this._predicates = rule.getPredicates();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this._identity, this._operation, this._object, this._predicates});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleKey ruleKey = (RuleKey)o;
            return Objects.equals(this._identity, ruleKey._identity) && Objects.equals((Object)this._operation, (Object)ruleKey._operation) && Objects.equals((Object)this._object, (Object)ruleKey._object) && Objects.equals(this._predicates, ruleKey._predicates);
        }

        public String toString() {
            return "RuleKey[identity=" + this._identity + ", operation=" + this._operation + ", object=" + this._object + ", predicates=" + this._predicates + "]";
        }
    }
}

