/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.security.access.config.DynamicRule;

public abstract class FirewallRule
implements DynamicRule {
    @Override
    public boolean matches(Subject subject) {
        InetAddress addressOfClient = this.getAddressOfClient(subject);
        if (addressOfClient == null) {
            return true;
        }
        return this.matches(addressOfClient);
    }

    private InetAddress getAddressOfClient(Subject subject) {
        SocketAddress address;
        Set<ConnectionPrincipal> principals = subject.getPrincipals(ConnectionPrincipal.class);
        if (!principals.isEmpty() && (address = principals.iterator().next().getConnection().getRemoteSocketAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getAddress();
        }
        return null;
    }

    protected abstract boolean matches(InetAddress var1);
}

