/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.firewall.FirewallRule;

public class AclAction {
    private Action _action;
    private FirewallRule _firewallRule;

    public AclAction(LegacyOperation operation, ObjectType object, AclRulePredicates predicates) {
        this._action = new Action(operation, object, predicates.getObjectProperties());
        this._firewallRule = predicates.getFirewallRule();
    }

    public AclAction(LegacyOperation operation) {
        this._action = new Action(operation);
    }

    public AclAction(LegacyOperation operation, ObjectType object, ObjectProperties properties) {
        this._action = new Action(operation, object, properties);
    }

    public FirewallRule getFirewallRule() {
        return this._firewallRule;
    }

    public Action getAction() {
        return this._action;
    }

    public boolean isAllowed() {
        return this._action.isSupported();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AclAction aclAction = (AclAction)o;
        if (this.getAction() != null ? !this.getAction().equals(aclAction.getAction()) : aclAction.getAction() != null) {
            return false;
        }
        return !(this.getFirewallRule() == null ? aclAction.getFirewallRule() != null : !this.getFirewallRule().equals(aclAction.getFirewallRule()));
    }

    public int hashCode() {
        int result = this.getAction() != null ? this.getAction().hashCode() : 0;
        result = 31 * result + (this.getFirewallRule() != null ? this.getFirewallRule().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AclAction[action=" + this._action + ", firewallRule=" + this._firewallRule + ']';
    }

    public Map<ObjectProperties.Property, String> getAttributes() {
        FirewallRule firewallRule;
        ObjectProperties properties = this._action.getProperties();
        HashMap<ObjectProperties.Property, String> attributes = new HashMap<ObjectProperties.Property, String>(properties.asPropertyMap());
        Set<String> attributeNames = properties.getAttributeNames();
        if (attributeNames != null && !attributeNames.isEmpty()) {
            attributes.put(ObjectProperties.Property.ATTRIBUTES, String.join((CharSequence)",", attributeNames));
        }
        if ((firewallRule = this.getFirewallRule()) != null) {
            attributes.put(firewallRule.getPropertyName(), firewallRule.getPropertyValue());
        }
        return attributes;
    }
}

