/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.AclAction;
import org.apache.qpid.server.security.access.config.AclFileParser;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleBasedAccessControl;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.plugins.AbstractLegacyAccessControlProvider;
import org.apache.qpid.server.security.access.plugins.AclRule;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;

abstract class AbstractCommonRuleBasedAccessControlProvider<X extends AbstractCommonRuleBasedAccessControlProvider<X, T, Y>, T extends EventLoggerProvider & ConfiguredObject<?>, Y extends CommonAccessControlProvider<Y>>
extends AbstractLegacyAccessControlProvider<X, T, Y>
implements EventLoggerProvider {
    @ManagedAttributeField
    private Result _defaultResult;
    @ManagedAttributeField
    private volatile List<AclRule> _rules;

    AbstractCommonRuleBasedAccessControlProvider(Map<String, Object> attributes, T parent) {
        super(attributes, parent);
    }

    protected void postSetAttributes(Set<String> actualUpdatedAttributes) {
        super.postSetAttributes(actualUpdatedAttributes);
        if (actualUpdatedAttributes.contains("defaultResult") || actualUpdatedAttributes.contains("rules")) {
            this.recreateAccessController();
        }
    }

    @Override
    protected RuleBasedAccessControl createRuleBasedAccessController() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (AclRule configuredRule : this._rules) {
            rules.add(new Rule(configuredRule.getIdentity(), new AclAction(configuredRule.getOperation(), configuredRule.getObjectType(), new AclRulePredicates(configuredRule.getAttributes())), configuredRule.getOutcome()));
        }
        return new RuleBasedAccessControl(new RuleSet(this, rules, this._defaultResult), this.getModel());
    }

    public Result getDefaultResult() {
        return this._defaultResult;
    }

    public List<AclRule> getRules() {
        return this._rules;
    }

    public void loadFromFile(String path) {
        RuleSet ruleSet = AclFileParser.parse(path, (EventLoggerProvider)this);
        ArrayList<AclRuleImpl> aclRules = new ArrayList<AclRuleImpl>();
        for (Rule rule : ruleSet.getAllRules()) {
            aclRules.add(new AclRuleImpl(rule));
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("defaultResult", ruleSet.getDefault());
        attrs.put("rules", aclRules);
        this.setAttributes(attrs);
    }

    public Content extractRules() {
        StringBuilder sb = new StringBuilder();
        switch (this._defaultResult) {
            case DENIED: {
                break;
            }
            case ALLOWED: 
            case DEFER: {
                sb.append(String.format("CONFIG %s=true\n", this._defaultResult == Result.ALLOWED ? "defaultallow" : "defaultdefer"));
            }
        }
        for (AclRule rule : this._rules) {
            sb.append("ACL ");
            sb.append(rule.getOutcome().name().replace('_', '-'));
            sb.append(' ');
            sb.append(rule.getIdentity());
            sb.append(' ');
            sb.append(rule.getOperation().name());
            sb.append(' ');
            sb.append(rule.getObjectType().name());
            for (Map.Entry<ObjectProperties.Property, String> entry : rule.getAttributes().entrySet()) {
                sb.append(' ');
                sb.append(entry.getKey().getCanonicalName());
                sb.append(" = \"");
                sb.append(entry.getValue());
                sb.append("\"");
            }
            sb.append('\n');
        }
        return new StringContent(this.getName(), sb.toString());
    }

    private static class StringContent
    implements Content,
    CustomRestHeaders {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss");
        private final String _content;
        private final String _name;

        public StringContent(String name, String content) {
            this._content = content;
            this._name = name;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this._content.getBytes(StandardCharsets.UTF_8));
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "text/plain";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return String.format("attachment; filename=\"%s-%s.acl\"", this._name, FORMATTER.format(LocalDateTime.now()));
        }

        public void release() {
        }
    }

    public static class AclRuleImpl
    implements AclRule {
        private final Rule _rule;

        AclRuleImpl(Rule rule) {
            this._rule = rule;
        }

        @Override
        public String getIdentity() {
            return this._rule.getIdentity();
        }

        @Override
        public ObjectType getObjectType() {
            return this._rule.getAction().getObjectType();
        }

        @Override
        public LegacyOperation getOperation() {
            return this._rule.getAction().getOperation();
        }

        @Override
        public Map<ObjectProperties.Property, String> getAttributes() {
            return this._rule.getAction().getProperties().asPropertyMap();
        }

        @Override
        public RuleOutcome getOutcome() {
            return this._rule.getRuleOutcome();
        }
    }
}

