/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;

public class Action {
    private final LegacyOperation _operation;
    private final ObjectType _object;
    private final ObjectProperties _properties;

    public Action(LegacyOperation operation) {
        this(operation, ObjectType.ALL);
    }

    public Action(LegacyOperation operation, ObjectType object, String name) {
        this(operation, object, new ObjectProperties(name));
    }

    public Action(LegacyOperation operation, ObjectType object) {
        this(operation, object, ObjectProperties.EMPTY);
    }

    public Action(LegacyOperation operation, ObjectType object, ObjectProperties properties) {
        this._operation = operation;
        this._object = object;
        this._properties = properties;
    }

    public LegacyOperation getOperation() {
        return this._operation;
    }

    public ObjectType getObjectType() {
        return this._object;
    }

    public ObjectProperties getProperties() {
        return this._properties;
    }

    boolean isSupported() {
        return this._object.isSupported(this._operation);
    }

    public boolean matches(Action a) {
        return this.operationsMatch(a) && this.objectTypesMatch(a) && this.propertiesMatch(a);
    }

    private boolean operationsMatch(Action a) {
        return LegacyOperation.ALL == a.getOperation() || this.getOperation() == a.getOperation();
    }

    private boolean objectTypesMatch(Action a) {
        return ObjectType.ALL == a.getObjectType() || this.getObjectType() == a.getObjectType();
    }

    private boolean propertiesMatch(Action a) {
        boolean propertiesMatch = false;
        if (this._properties != null) {
            propertiesMatch = this._properties.matches(a.getProperties());
        } else if (a.getProperties() == null) {
            propertiesMatch = true;
        }
        return propertiesMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.getOperation() != action.getOperation()) {
            return false;
        }
        if (this._object != action._object) {
            return false;
        }
        return !(this.getProperties() == null ? action.getProperties() != null : !this.getProperties().equals(action.getProperties()));
    }

    public int hashCode() {
        int result = this.getOperation() != null ? this.getOperation().hashCode() : 0;
        result = 31 * result + (this._object != null ? this._object.hashCode() : 0);
        result = 31 * result + (this.getProperties() != null ? this.getProperties().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Action[operation=" + (Object)((Object)this._operation) + ", object=" + (Object)((Object)this._object) + ", properties=" + this._properties + ']';
    }
}

