/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.access.AbstractAccessControlProvider;
import org.apache.qpid.server.security.access.config.RuleBasedAccessControl;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLegacyAccessControlProvider<X extends AbstractLegacyAccessControlProvider<X, T, Y>, T extends EventLoggerProvider & ConfiguredObject<?>, Y extends CommonAccessControlProvider<Y>>
extends AbstractAccessControlProvider<X, Y, T>
implements EventLoggerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLegacyAccessControlProvider.class);
    private volatile RuleBasedAccessControl _accessControl;

    AbstractLegacyAccessControlProvider(Map<String, Object> attributes, T parent) {
        super(attributes, parent);
    }

    public void onValidate() {
        super.onValidate();
        if (!this.isDurable()) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " must be durable");
        }
    }

    protected void validateOnCreate() {
        try {
            this.createRuleBasedAccessController();
        }
        catch (RuntimeException e) {
            throw new IllegalConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract RuleBasedAccessControl createRuleBasedAccessController();

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        boolean isManagementMode = ((SystemConfig)this.getModel().getAncestor(SystemConfig.class, (ConfiguredObject)this)).isManagementMode();
        try {
            this.recreateAccessController();
            this.setState(isManagementMode ? State.QUIESCED : State.ACTIVE);
        }
        catch (RuntimeException e) {
            this.setState(State.ERRORED);
            if (isManagementMode) {
                LOGGER.warn("Failed to activate ACL provider: " + this.getName(), (Throwable)e);
            }
            throw e;
        }
        return Futures.immediateFuture(null);
    }

    protected final void recreateAccessController() {
        this._accessControl = this.createRuleBasedAccessController();
    }

    public final AccessControl getAccessControl() {
        return this._accessControl;
    }

    static {
        Handler.register();
    }
}

