/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.config.ClientAction;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.plugins.RuleOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSet
implements EventLoggerProvider {
    private static final Logger _logger = LoggerFactory.getLogger(RuleSet.class);
    public static final String DEFAULT_ALLOW = "defaultallow";
    public static final String DEFAULT_DENY = "defaultdeny";
    private static final Integer _increment = 10;
    private final List<Rule> _rules;
    private final Map<Subject, Map<LegacyOperation, Map<ObjectType, List<Rule>>>> _cache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, Boolean> _config = new HashMap<String, Boolean>();
    private final EventLoggerProvider _eventLogger;
    private Result _defaultResult = Result.DENIED;

    public RuleSet(EventLoggerProvider eventLogger, Collection<Rule> rules, Result defaultResult) {
        this._eventLogger = eventLogger;
        this._rules = new ArrayList<Rule>(rules);
        this._defaultResult = defaultResult;
    }

    int getRuleCount() {
        return this._rules.size();
    }

    private List<Rule> getRules(Subject subject, LegacyOperation operation, ObjectType objectType) {
        Map<ObjectType, List<Rule>> objects = this.getObjectToRuleCache(subject, operation);
        if (!objects.containsKey((Object)objectType)) {
            Set<Principal> principals = subject.getPrincipals();
            boolean controlled = false;
            LinkedList<Rule> filtered = new LinkedList<Rule>();
            for (Rule rule : this._rules) {
                Action ruleAction = rule.getAction();
                if (ruleAction.getOperation() != LegacyOperation.ALL && ruleAction.getOperation() != operation || ruleAction.getObjectType() != ObjectType.ALL && ruleAction.getObjectType() != objectType) continue;
                controlled = true;
                if (!this.isRelevant(principals, rule)) continue;
                filtered.add(rule);
            }
            if (filtered.isEmpty() && !controlled) {
                filtered = null;
            }
            objects.put(objectType, filtered);
            _logger.debug("Cached {} RulesList: {}", (Object)objectType, filtered);
        }
        List<Rule> rules = objects.get((Object)objectType);
        _logger.debug("Returning RuleList: {}", rules);
        return rules;
    }

    public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
        return this.check(subject, operation, objectType, properties, null);
    }

    public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties, InetAddress addressOfClient) {
        ClientAction action = new ClientAction(operation, objectType, properties);
        _logger.debug("Checking action: {}", (Object)action);
        List<Rule> rules = this.getRules(subject, operation, objectType);
        if (rules == null) {
            _logger.debug("No rules found, returning default result");
            return this.getDefault();
        }
        for (Rule rule : rules) {
            _logger.debug("Checking against rule: {}", (Object)rule);
            if (!action.matches(rule.getAclAction(), addressOfClient)) continue;
            RuleOutcome ruleOutcome = rule.getRuleOutcome();
            _logger.debug("Action matches.  Result: {}", (Object)ruleOutcome);
            boolean allowed = ruleOutcome.isAllowed();
            if (ruleOutcome.isLogged()) {
                if (allowed) {
                    this.getEventLogger().message(AccessControlMessages.ALLOWED((String)action.getOperation().toString(), (String)action.getObjectType().toString(), (String)action.getProperties().toString()));
                } else {
                    this.getEventLogger().message(AccessControlMessages.DENIED((String)action.getOperation().toString(), (String)action.getObjectType().toString(), (String)action.getProperties().toString()));
                }
            }
            return allowed ? Result.ALLOWED : Result.DENIED;
        }
        _logger.debug("Deferring result of ACL check");
        return Result.DEFER;
    }

    public Result getDefault() {
        return this._defaultResult;
    }

    public void configure(Map<String, Boolean> properties) {
        this._config.putAll(properties);
    }

    public List<Rule> getAllRules() {
        return Collections.unmodifiableList(this._rules);
    }

    private boolean isRelevant(Set<Principal> principals, Rule rule) {
        if (rule.getIdentity().equalsIgnoreCase("all")) {
            return true;
        }
        for (Principal principal : principals) {
            if (!rule.getIdentity().equalsIgnoreCase(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private Map<ObjectType, List<Rule>> getObjectToRuleCache(Subject subject, LegacyOperation operation) {
        Map<ObjectType, List<Rule>> objects;
        Map<LegacyOperation, Map<ObjectType, List<Rule>>> operations = this._cache.get(subject);
        if (operations == null) {
            operations = Collections.synchronizedMap(new EnumMap(LegacyOperation.class));
            this._cache.put(subject, operations);
        }
        if ((objects = operations.get((Object)operation)) == null) {
            objects = Collections.synchronizedMap(new EnumMap(ObjectType.class));
            operations.put(operation, objects);
        }
        return objects;
    }

    public EventLogger getEventLogger() {
        return this._eventLogger.getEventLogger();
    }
}

