/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.util.List;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.plugins.AclRule;

@ManagedObject(category=false, type="RuleBased")
public interface RuleBasedAccessControlProvider<X extends RuleBasedAccessControlProvider<X>>
extends AccessControlProvider<X> {
    public static final String RULE_BASED_TYPE = "RuleBased";
    public static final String DEFAULT_RESULT = "defaultResult";
    public static final String RULES = "rules";

    @ManagedAttribute(mandatory=true, defaultValue="DENIED", validValues={"ALLOWED", "DENIED"}, description="the default resil to use if no rules match the requested operation")
    public Result getDefaultResult();

    @ManagedAttribute(mandatory=true, defaultValue="[ { \"identity\" : \"ALL\", \"objectType\" : \"ALL\", \"operation\" : \"ALL\", \"attributes\" : {}, \"outcome\" : \"ALLOW\"} ]", description="the ordered list of ACL rules")
    public List<AclRule> getRules();

    @ManagedOperation(description="Load access control rules from a file in the legacy access control rule format", changesConfiguredObjectState=true)
    public void loadFromFile(@Param(name="path") String var1);

    @ManagedOperation(nonModifying=true, description="Extract the access control rules in the legacy access control rule format", changesConfiguredObjectState=false)
    public Content extractRules();
}

