/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;

public class Action {
    private final Operation _operation;
    private final ObjectType _object;
    private final ObjectProperties _properties;

    public Action(Operation operation) {
        this(operation, ObjectType.ALL);
    }

    public Action(Operation operation, ObjectType object, String name) {
        this(operation, object, new ObjectProperties(name));
    }

    public Action(Operation operation, ObjectType object) {
        this(operation, object, ObjectProperties.EMPTY);
    }

    public Action(Operation operation, ObjectType object, ObjectProperties properties) {
        this._operation = operation;
        this._object = object;
        this._properties = properties;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public ObjectType getObjectType() {
        return this._object;
    }

    public ObjectProperties getProperties() {
        return this._properties;
    }

    public boolean isAllowed() {
        return this._object.isAllowed(this._operation);
    }

    public boolean matches(Action a) {
        if (!this.operationsMatch(a)) {
            return false;
        }
        if (!this.objectTypesMatch(a)) {
            return false;
        }
        return this.propertiesMatch(a);
    }

    private boolean operationsMatch(Action a) {
        return Operation.ALL == a.getOperation() || this.getOperation() == a.getOperation();
    }

    private boolean objectTypesMatch(Action a) {
        return ObjectType.ALL == a.getObjectType() || this.getObjectType() == a.getObjectType();
    }

    private boolean propertiesMatch(Action a) {
        boolean propertiesMatch = false;
        if (this._properties != null) {
            propertiesMatch = this._properties.matches(a.getProperties());
        } else if (a.getProperties() == null) {
            propertiesMatch = true;
        }
        return propertiesMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.getOperation() != action.getOperation()) {
            return false;
        }
        if (this._object != action._object) {
            return false;
        }
        return !(this.getProperties() == null ? action.getProperties() != null : !this.getProperties().equals((Object)action.getProperties()));
    }

    public int hashCode() {
        int result = this.getOperation() != null ? this.getOperation().hashCode() : 0;
        result = 31 * result + (this._object != null ? this._object.hashCode() : 0);
        result = 31 * result + (this.getProperties() != null ? this.getProperties().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Action[operation=" + this._operation + ", object=" + this._object + ", properties=" + this._properties + ']';
    }
}

