/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.Permission;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.ConfigurationFile;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainConfiguration
implements ConfigurationFile {
    private static final Logger _logger = LoggerFactory.getLogger(PlainConfiguration.class);
    public static final Character COMMENT = Character.valueOf('#');
    public static final Character CONTINUATION = Character.valueOf('\\');
    public static final String ACL = "acl";
    public static final String CONFIG = "config";
    static final String UNRECOGNISED_INITIAL_MSG = "Unrecognised initial token '%s' at line %d";
    static final String NOT_ENOUGH_TOKENS_MSG = "Not enough tokens at line %d";
    static final String NUMBER_NOT_ALLOWED_MSG = "Number not allowed before '%s' at line %d";
    static final String CANNOT_LOAD_MSG = "Cannot load config file %s";
    static final String CANNOT_CLOSE_MSG = "Cannot close config file %s";
    static final String PREMATURE_CONTINUATION_MSG = "Premature continuation character at line %d";
    static final String PREMATURE_EOF_MSG = "Premature end of file reached at line %d";
    static final String PARSE_TOKEN_FAILED_MSG = "Failed to parse token at line %d";
    static final String CONFIG_NOT_FOUND_MSG = "Cannot find config file %s";
    static final String NOT_ENOUGH_ACL_MSG = "Not enough data for an acl at line %d";
    static final String NOT_ENOUGH_CONFIG_MSG = "Not enough data for config at line %d";
    static final String BAD_ACL_RULE_NUMBER_MSG = "Invalid rule number at line %d";
    static final String PROPERTY_KEY_ONLY_MSG = "Incomplete property (key only) at line %d";
    static final String PROPERTY_NO_EQUALS_MSG = "Incomplete property (no equals) at line %d";
    static final String PROPERTY_NO_VALUE_MSG = "Incomplete property (no value) at line %d";
    private final EventLoggerProvider _eventLogger;
    private final String _name;
    private StreamTokenizer _st;
    private RuleSet _config;

    public PlainConfiguration(String name, EventLoggerProvider eventLogger) {
        this._eventLogger = eventLogger;
        this._name = name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RuleSet load(Reader configReader) {
        this._config = new RuleSet(this._eventLogger);
        try (Reader fileReader = configReader;){
            int current;
            _logger.debug("About to load ACL file");
            this._st = new StreamTokenizer(new BufferedReader(fileReader));
            this._st.resetSyntax();
            this._st.commentChar(COMMENT.charValue());
            this._st.eolIsSignificant(true);
            this._st.ordinaryChar(61);
            this._st.ordinaryChar(CONTINUATION.charValue());
            this._st.quoteChar(34);
            this._st.quoteChar(39);
            this._st.whitespaceChars(0, 32);
            this._st.wordChars(97, 122);
            this._st.wordChars(65, 90);
            this._st.wordChars(48, 57);
            this._st.wordChars(95, 95);
            this._st.wordChars(45, 45);
            this._st.wordChars(46, 46);
            this._st.wordChars(42, 42);
            this._st.wordChars(64, 64);
            this._st.wordChars(58, 58);
            Stack<String> stack = new Stack<String>();
            block18: do {
                current = this._st.nextToken();
                switch (current) {
                    case -1: 
                    case 10: {
                        if (stack.isEmpty()) continue block18;
                        String first = (String)stack.firstElement();
                        stack.removeElementAt(0);
                        if (stack.isEmpty()) {
                            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_TOKENS_MSG, this.getLine()));
                        }
                        Integer number = null;
                        if (first != null && first.matches("\\d+")) {
                            number = Integer.valueOf(first);
                            first = (String)stack.firstElement();
                            stack.removeElementAt(0);
                        }
                        if (ACL.equalsIgnoreCase(first)) {
                            this.parseAcl(number, stack);
                        } else {
                            if (number != null) throw new IllegalConfigurationException(String.format(NUMBER_NOT_ALLOWED_MSG, first, this.getLine()));
                            if ("GROUP".equalsIgnoreCase(first)) {
                                throw new IllegalConfigurationException(String.format("GROUP keyword not supported at line %d. Groups should defined via a Group Provider, not in the ACL file.", this.getLine()));
                            }
                            if (!CONFIG.equalsIgnoreCase(first)) throw new IllegalConfigurationException(String.format(UNRECOGNISED_INITIAL_MSG, first, this.getLine()));
                            this.parseConfig(stack);
                        }
                        stack.clear();
                        break;
                    }
                    case -2: {
                        stack.push(Integer.toString(Double.valueOf(this._st.nval).intValue()));
                        break;
                    }
                    case -3: {
                        stack.push(this._st.sval);
                        break;
                    }
                    default: {
                        if (this._st.ttype == CONTINUATION.charValue()) {
                            int next = this._st.nextToken();
                            if (next == 10) continue block18;
                            throw new IllegalConfigurationException(String.format(PREMATURE_CONTINUATION_MSG, this.getLine() + 1));
                        }
                        if (this._st.ttype == 39 || this._st.ttype == 34) {
                            stack.push(this._st.sval);
                            break;
                        }
                        stack.push(Character.toString((char)this._st.ttype));
                    }
                }
            } while (current != -1);
            if (stack.isEmpty()) return this._config;
            throw new IllegalConfigurationException(String.format(PREMATURE_EOF_MSG, this.getLine()));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalConfigurationException(String.format(PARSE_TOKEN_FAILED_MSG, this.getLine()), (Throwable)iae);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalConfigurationException(String.format(CONFIG_NOT_FOUND_MSG, this._name), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new IllegalConfigurationException(String.format(CANNOT_LOAD_MSG, this._name), (Throwable)ioe);
        }
    }

    private void parseAcl(Integer number, List<String> args) {
        if (args.size() < 3) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_ACL_MSG, this.getLine()));
        }
        Permission permission = Permission.parse((String)args.get(0));
        String identity = args.get(1);
        Operation operation = Operation.parse((String)args.get(2));
        if (number != null && !this.getConfiguration().isValidNumber(number)) {
            throw new IllegalConfigurationException(String.format(BAD_ACL_RULE_NUMBER_MSG, this.getLine()));
        }
        if (args.size() == 3) {
            this.getConfiguration().grant(number, identity, permission, operation);
        } else {
            ObjectType object = ObjectType.parse((String)args.get(3));
            AclRulePredicates predicates = this.toRulePredicates(args.subList(4, args.size()));
            this.getConfiguration().grant(number, identity, permission, operation, object, predicates);
        }
    }

    private void parseConfig(List<String> args) {
        if (args.size() < 3) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_CONFIG_MSG, this.getLine()));
        }
        Map<String, Boolean> properties = this.toPluginProperties(args);
        this.getConfiguration().configure(properties);
    }

    private AclRulePredicates toRulePredicates(List<String> args) {
        AclRulePredicates predicates = new AclRulePredicates();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, this.getLine()));
            }
            if (!"=".equals(i.next())) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, this.getLine()));
            }
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, this.getLine()));
            }
            String value = i.next();
            predicates.parse(key, value);
        }
        return predicates;
    }

    protected Map<String, Boolean> toPluginProperties(List<String> args) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = i.next().toLowerCase();
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, this.getLine()));
            }
            if (!"=".equals(i.next())) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, this.getLine()));
            }
            if (!i.hasNext()) {
                throw new IllegalConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, this.getLine()));
            }
            Boolean value = Boolean.valueOf(i.next());
            properties.put(key, value);
        }
        return properties;
    }

    protected int getLine() {
        return this._st.lineno() - 1;
    }

    @Override
    public RuleSet getConfiguration() {
        return this._config;
    }
}

