/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.registry.ApplicationRegistry;

public class AccessControlMessages {
    private static ResourceBundle _messages;
    private static Locale _currentLocale;
    public static final String ACCESSCONTROL_LOG_HIERARCHY = "qpid.message.accesscontrol";
    public static final String DENIED_LOG_HIERARCHY = "qpid.message.accesscontrol.denied";
    public static final String ALLOWED_LOG_HIERARCHY = "qpid.message.accesscontrol.allowed";

    public static void reload() {
        _currentLocale = ApplicationRegistry.isConfigured() ? ApplicationRegistry.getInstance().getConfiguration().getLocale() : Locale.getDefault();
        _messages = ResourceBundle.getBundle("org.apache.qpid.server.security.access.logging.AccessControl_logmessages", _currentLocale);
    }

    public static LogMessage DENIED(String param1, String param2, String param3) {
        String rawMessage = _messages.getString("DENIED");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return AccessControlMessages.DENIED_LOG_HIERARCHY;
            }
        };
    }

    public static LogMessage ALLOWED(String param1, String param2, String param3) {
        String rawMessage = _messages.getString("ALLOWED");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, _currentLocale);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            public String getLogHierarchy() {
                return AccessControlMessages.ALLOWED_LOG_HIERARCHY;
            }
        };
    }

    private AccessControlMessages() {
    }

    static {
        Logger.getLogger((String)ACCESSCONTROL_LOG_HIERARCHY);
        Logger.getLogger((String)DENIED_LOG_HIERARCHY);
        Logger.getLogger((String)ALLOWED_LOG_HIERARCHY);
        AccessControlMessages.reload();
    }
}

