/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.access.firewall.AccessControlFirewallException;
import org.apache.qpid.server.security.access.firewall.FirewallRule;

public class HostnameFirewallRule
implements FirewallRule {
    private static final Logger _logger = Logger.getLogger(HostnameFirewallRule.class);
    private static final long DNS_TIMEOUT = 30000L;
    private static final ExecutorService DNS_LOOKUP = Executors.newCachedThreadPool();
    private Pattern[] _hostnamePatterns;
    private String[] _hostnames;

    public HostnameFirewallRule(String ... hostnames) {
        this._hostnames = hostnames;
        int i = 0;
        this._hostnamePatterns = new Pattern[hostnames.length];
        for (String hostname : hostnames) {
            this._hostnamePatterns[i++] = Pattern.compile(hostname);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created " + this));
        }
    }

    public boolean matches(InetAddress remote) {
        String hostname = this.getHostname(remote);
        if (hostname == null) {
            throw new AccessControlFirewallException("DNS lookup failed for address " + remote);
        }
        for (Pattern pattern : this._hostnamePatterns) {
            boolean hostnameMatches = pattern.matcher(hostname).matches();
            if (!hostnameMatches) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Hostname " + hostname + " matches rule " + pattern.toString()));
            }
            return true;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Hostname " + hostname + " matches no configured hostname patterns"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHostname(final InetAddress remote) throws AccessControlFirewallException {
        FutureTask<String> lookup = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                return remote.getCanonicalHostName();
            }
        });
        DNS_LOOKUP.execute(lookup);
        try {
            String string = lookup.get(30000L, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (Exception e) {
            _logger.warn((Object)("Unable to look up hostname from address " + remote), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            lookup.cancel(true);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object[])this._hostnames).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HostnameFirewallRule rhs = (HostnameFirewallRule)obj;
        return new EqualsBuilder().append((Object[])this._hostnames, (Object[])rhs._hostnames).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object[])this._hostnames).toString();
    }
}

