/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.qpid.server.security.access.ObjectProperties;
import org.apache.qpid.server.security.access.ObjectType;
import org.apache.qpid.server.security.access.Operation;

public class Action {
    private final Operation _operation;
    private final ObjectType _object;
    private final ObjectProperties _properties;

    public Action(Operation operation) {
        this(operation, ObjectType.ALL);
    }

    public Action(Operation operation, ObjectType object, String name) {
        this(operation, object, new ObjectProperties(name));
    }

    public Action(Operation operation, ObjectType object) {
        this(operation, object, ObjectProperties.EMPTY);
    }

    public Action(Operation operation, ObjectType object, ObjectProperties properties) {
        this._operation = operation;
        this._object = object;
        this._properties = properties;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public ObjectType getObjectType() {
        return this._object;
    }

    public ObjectProperties getProperties() {
        return this._properties;
    }

    public boolean isAllowed() {
        return this._object.isAllowed(this._operation);
    }

    public boolean matches(Action a) {
        if (!this.operationsMatch(a)) {
            return false;
        }
        if (!this.objectTypesMatch(a)) {
            return false;
        }
        return this.propertiesMatch(a);
    }

    private boolean operationsMatch(Action a) {
        return Operation.ALL == a.getOperation() || this.getOperation() == a.getOperation();
    }

    private boolean objectTypesMatch(Action a) {
        return ObjectType.ALL == a.getObjectType() || this.getObjectType() == a.getObjectType();
    }

    private boolean propertiesMatch(Action a) {
        boolean propertiesMatch = false;
        if (this._properties != null) {
            propertiesMatch = this._properties.matches(a.getProperties());
        } else if (a.getProperties() == null) {
            propertiesMatch = true;
        }
        return propertiesMatch;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Action)) {
            return false;
        }
        Action a = (Action)o;
        return new EqualsBuilder().append((Object)this._operation, (Object)a.getOperation()).append((Object)this._object, (Object)a.getObjectType()).append((Object)this._properties, (Object)a.getProperties()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._operation).append((Object)this._object).append((Object)this._properties).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("operation", (Object)this._operation).append("objectType", (Object)this._object).append("properties", (Object)this._properties).toString();
    }
}

