/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;

public final class Hyperlinks {
    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            FileInputStream is = new FileInputStream(arg);
            HSLFSlideShow ppt = new HSLFSlideShow((InputStream)is);
            is.close();
            for (HSLFSlide slide : ppt.getSlides()) {
                System.out.println("\nslide " + slide.getSlideNumber());
                System.out.println("- reading hyperlinks from the text runs");
                for (List paras : slide.getTextParagraphs()) {
                    for (HSLFTextParagraph para : paras) {
                        for (HSLFTextRun run : para) {
                            HSLFHyperlink link = run.getHyperlink();
                            if (link == null) continue;
                            System.out.println(Hyperlinks.toStr(link, run.getRawText()));
                        }
                    }
                }
                System.out.println("- reading hyperlinks from the slide's shapes");
                for (HSLFShape sh : slide.getShapes()) {
                    HSLFHyperlink link;
                    if (!(sh instanceof HSLFSimpleShape) || (link = ((HSLFSimpleShape)sh).getHyperlink()) == null) continue;
                    System.out.println(Hyperlinks.toStr(link, null));
                }
            }
            ppt.close();
        }
    }

    static String toStr(HSLFHyperlink link, String rawText) {
        String formatStr = "title: %1$s, address: %2$s" + (rawText == null ? "" : ", start: %3$s, end: %4$s, substring: %5$s");
        return String.format(Locale.ROOT, formatStr, link.getLabel(), link.getAddress(), link.getStartIndex(), link.getEndIndex(), rawText);
    }
}

