/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSPerformanceTest {
    public static void main(String[] args) {
        if (args.length != 4) {
            SSPerformanceTest.usage("need four command arguments");
        }
        String type = args[0];
        long timeStarted = System.currentTimeMillis();
        Workbook workBook = SSPerformanceTest.createWorkbook(type);
        boolean isHType = workBook instanceof HSSFWorkbook;
        int rows = SSPerformanceTest.parseInt(args[1], "Failed to parse rows value as integer");
        int cols = SSPerformanceTest.parseInt(args[2], "Failed to parse cols value as integer");
        boolean saveFile = SSPerformanceTest.parseInt(args[3], "Failed to parse saveFile value as integer") != 0;
        Map<String, CellStyle> styles = SSPerformanceTest.createStyles(workBook);
        Sheet sheet = workBook.createSheet("Main Sheet");
        Cell headerCell = sheet.createRow(0).createCell(0);
        headerCell.setCellValue("Header text is spanned across multiple cells");
        headerCell.setCellStyle(styles.get("header"));
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$A$1:$F$1"));
        int sheetNo = 0;
        int rowIndexInSheet = 1;
        double value = 0.0;
        Calendar calendar = Calendar.getInstance();
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            if (isHType && sheetNo != rowIndex / 65536) {
                sheet = workBook.createSheet("Spillover from sheet " + ++sheetNo);
                headerCell.setCellValue("Header text is spanned across multiple cells");
                headerCell.setCellStyle(styles.get("header"));
                sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$A$1:$F$1"));
                rowIndexInSheet = 1;
            }
            Row row = sheet.createRow(rowIndexInSheet);
            block11: for (int colIndex = 0; colIndex < cols; ++colIndex) {
                Cell cell = row.createCell(colIndex);
                String address = new CellReference(cell).formatAsString();
                switch (colIndex) {
                    case 0: {
                        double d = value;
                        value = d + 1.0;
                        cell.setCellValue(d);
                        continue block11;
                    }
                    case 1: {
                        double d = value;
                        value = d + 1.0;
                        cell.setCellValue(d);
                        cell.setCellStyle(styles.get("#,##0.00"));
                        continue block11;
                    }
                    case 2: {
                        double d = value;
                        value = d + 1.0;
                        cell.setCellValue(d);
                        cell.setCellStyle(styles.get("$#,##0.00"));
                        continue block11;
                    }
                    case 3: {
                        cell.setCellValue(address);
                        cell.setCellStyle(styles.get("red-bold"));
                        continue block11;
                    }
                    case 4: {
                        cell.setCellValue(rowIndex % 2 == 0);
                        continue block11;
                    }
                    case 5: {
                        cell.setCellValue(calendar);
                        cell.setCellStyle(styles.get("m/d/yyyy"));
                        calendar.roll(6, -1);
                        continue block11;
                    }
                    default: {
                        double d = value;
                        value = d + 1.0;
                        cell.setCellValue(d);
                    }
                }
            }
            ++rowIndexInSheet;
        }
        if (saveFile) {
            String fileName = type + "_" + rows + "_" + cols + "." + SSPerformanceTest.getFileSuffix(args[0]);
            try {
                FileOutputStream out = new FileOutputStream(fileName);
                workBook.write((OutputStream)out);
                out.close();
            }
            catch (IOException ioe) {
                System.err.println("Error: failed to write to file \"" + fileName + "\", reason=" + ioe.getMessage());
            }
        }
        long timeFinished = System.currentTimeMillis();
        System.out.println("Elapsed " + (timeFinished - timeStarted) / 1000L + " seconds");
    }

    static Map<String, CellStyle> createStyles(Workbook wb) {
        String[] nfmt;
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        Font headerFont = wb.createFont();
        headerFont.setFontHeightInPoints((short)14);
        headerFont.setBoldweight((short)700);
        CellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFont(headerFont);
        style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        style.setFillPattern((short)1);
        styles.put("header", style);
        Font monthFont = wb.createFont();
        monthFont.setFontHeightInPoints((short)12);
        monthFont.setColor(IndexedColors.RED.getIndex());
        monthFont.setBoldweight((short)700);
        style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setFillPattern((short)1);
        style.setFont(monthFont);
        styles.put("red-bold", style);
        for (String fmt : nfmt = new String[]{"#,##0.00", "$#,##0.00", "m/d/yyyy"}) {
            style = wb.createCellStyle();
            style.setDataFormat(wb.createDataFormat().getFormat(fmt));
            styles.put(fmt, style);
        }
        return styles;
    }

    static void usage(String message) {
        System.err.println(message);
        System.err.println("usage: java SSPerformanceTest HSSF|XSSF|SXSSF rows cols saveFile (0|1)? ");
        System.exit(1);
    }

    static Workbook createWorkbook(String type) {
        if ("HSSF".equals(type)) {
            return new HSSFWorkbook();
        }
        if ("XSSF".equals(type)) {
            return new XSSFWorkbook();
        }
        if ("SXSSF".equals(type)) {
            return new SXSSFWorkbook();
        }
        SSPerformanceTest.usage("Unknown type \"" + type + "\"");
        return null;
    }

    static String getFileSuffix(String type) {
        if ("HSSF".equals(type)) {
            return "xls";
        }
        if ("XSSF".equals(type)) {
            return "xlsx";
        }
        if ("SXSSF".equals(type)) {
            return "xlsx";
        }
        return null;
    }

    static int parseInt(String value, String msg) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            SSPerformanceTest.usage(msg);
            return 0;
        }
    }
}

