/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;

public final class HSSFReadWrite {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HSSFWorkbook readFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)fis);
            return hSSFWorkbook;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCreateSampleSheet(String outputFilename) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell c;
            int cellnum;
            HSSFRow r;
            int rownum;
            HSSFSheet s = wb.createSheet();
            HSSFCellStyle cs = wb.createCellStyle();
            HSSFCellStyle cs2 = wb.createCellStyle();
            HSSFCellStyle cs3 = wb.createCellStyle();
            HSSFFont f = wb.createFont();
            HSSFFont f2 = wb.createFont();
            f.setFontHeightInPoints((short)12);
            f.setColor((short)10);
            f.setBold(true);
            f2.setFontHeightInPoints((short)10);
            f2.setColor((short)15);
            f2.setBold(true);
            cs.setFont(f);
            cs.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"($#,##0_);[Red]($#,##0)"));
            cs2.setBorderBottom(BorderStyle.THIN);
            cs2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs2.setFillForegroundColor((short)10);
            cs2.setFont(f2);
            wb.setSheetName(0, "HSSF Test");
            for (rownum = 0; rownum < 300; ++rownum) {
                r = s.createRow(rownum);
                if (rownum % 2 == 0) {
                    r.setHeight((short)585);
                }
                for (cellnum = 0; cellnum < 50; cellnum += 2) {
                    c = r.createCell(cellnum);
                    c.setCellValue((double)(rownum * 10000 + cellnum) + ((double)rownum / 1000.0 + (double)cellnum / 10000.0));
                    if (rownum % 2 == 0) {
                        c.setCellStyle(cs);
                    }
                    c = r.createCell(cellnum + 1);
                    c.setCellValue((RichTextString)new HSSFRichTextString("TEST"));
                    s.setColumnWidth(cellnum + 1, 8000);
                    if (rownum % 2 != 0) continue;
                    c.setCellStyle(cs2);
                }
            }
            ++rownum;
            r = s.createRow(++rownum);
            cs3.setBorderBottom(BorderStyle.THICK);
            for (cellnum = 0; cellnum < 50; ++cellnum) {
                c = r.createCell(cellnum);
                c.setCellStyle(cs3);
            }
            s.addMergedRegion(new CellRangeAddress(0, 3, 0, 3));
            s.addMergedRegion(new CellRangeAddress(100, 110, 100, 110));
            wb.createSheet();
            wb.setSheetName(1, "DeletedSheet");
            wb.removeSheetAt(1);
            FileOutputStream out = new FileOutputStream(outputFilename);
            try {
                wb.write((OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        finally {
            wb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block34: {
            if (args.length < 1) {
                System.err.println("At least one argument expected");
                return;
            }
            String fileName = args[0];
            try {
                if (args.length < 2) {
                    HSSFWorkbook wb = HSSFReadWrite.readFile(fileName);
                    try {
                        System.out.println("Data dump:\n");
                        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
                            HSSFSheet sheet = wb.getSheetAt(k);
                            int rows = sheet.getPhysicalNumberOfRows();
                            System.out.println("Sheet " + k + " \"" + wb.getSheetName(k) + "\" has " + rows + " row(s).");
                            for (int r = 0; r < rows; ++r) {
                                HSSFRow row = sheet.getRow(r);
                                if (row == null) continue;
                                System.out.println("\nROW " + row.getRowNum() + " has " + row.getPhysicalNumberOfCells() + " cell(s).");
                                for (int c = 0; c < row.getLastCellNum(); ++c) {
                                    String value;
                                    HSSFCell cell = row.getCell(c);
                                    if (cell == null) continue;
                                    switch (cell.getCellTypeEnum()) {
                                        case FORMULA: {
                                            value = "FORMULA value=" + cell.getCellFormula();
                                            break;
                                        }
                                        case NUMERIC: {
                                            value = "NUMERIC value=" + cell.getNumericCellValue();
                                            break;
                                        }
                                        case STRING: {
                                            value = "STRING value=" + cell.getStringCellValue();
                                            break;
                                        }
                                        case BLANK: {
                                            value = "<BLANK>";
                                            break;
                                        }
                                        case BOOLEAN: {
                                            value = "BOOLEAN value-" + cell.getBooleanCellValue();
                                            break;
                                        }
                                        case ERROR: {
                                            value = "ERROR value=" + cell.getErrorCellValue();
                                            break;
                                        }
                                        default: {
                                            value = "UNKNOWN value of type " + cell.getCellTypeEnum();
                                        }
                                    }
                                    System.out.println("CELL col=" + cell.getColumnIndex() + " VALUE=" + value);
                                }
                            }
                        }
                        break block34;
                    }
                    finally {
                        wb.close();
                    }
                }
                if (args.length == 2) {
                    if (args[1].toLowerCase(Locale.ROOT).equals("write")) {
                        System.out.println("Write mode");
                        long time = System.currentTimeMillis();
                        HSSFReadWrite.testCreateSampleSheet(fileName);
                        System.out.println("" + (System.currentTimeMillis() - time) + " ms generation time");
                        break block34;
                    }
                    System.out.println("readwrite test");
                    HSSFWorkbook wb = HSSFReadWrite.readFile(fileName);
                    try {
                        FileOutputStream stream = new FileOutputStream(args[1]);
                        try {
                            wb.write((OutputStream)stream);
                            break block34;
                        }
                        finally {
                            stream.close();
                        }
                    }
                    finally {
                        wb.close();
                    }
                }
                if (args.length != 3 || !args[2].equalsIgnoreCase("modify1")) break block34;
                HSSFWorkbook wb = HSSFReadWrite.readFile(fileName);
                try {
                    HSSFRow row;
                    int k;
                    HSSFSheet sheet = wb.getSheetAt(0);
                    for (k = 0; k < 25; ++k) {
                        row = sheet.getRow(k);
                        sheet.removeRow((Row)row);
                    }
                    for (k = 74; k < 100; ++k) {
                        row = sheet.getRow(k);
                        sheet.removeRow((Row)row);
                    }
                    HSSFRow row2 = sheet.getRow(39);
                    HSSFCell cell = row2.getCell(3);
                    cell.setCellValue("MODIFIED CELL!!!!!");
                    FileOutputStream stream = new FileOutputStream(args[1]);
                    try {
                        wb.write((OutputStream)stream);
                    }
                    finally {
                        stream.close();
                    }
                }
                finally {
                    wb.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

