/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.pcap.netty.config;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.plc4x.java.utils.pcap.netty.config.PcapChannelOption;
import org.apache.plc4x.java.utils.pcap.netty.handlers.PacketHandler;
import org.pcap4j.packet.Packet;

public class PcapChannelConfig
extends DefaultChannelConfig
implements ChannelConfig {
    public static final int ALL_PROTOCOLS = -1;
    public static final int ALL_PORTS = -1;
    private boolean supportVlans = false;
    private int protocolId = -1;
    private int port = -1;
    private PacketHandler packetHandler = Packet::getRawData;

    public PcapChannelConfig(Channel channel) {
        super(channel);
    }

    public PcapChannelConfig clone() {
        PcapChannelConfig clone = new PcapChannelConfig(this.channel);
        clone.supportVlans = this.supportVlans;
        clone.protocolId = this.protocolId;
        clone.port = this.port;
        clone.packetHandler = this.packetHandler;
        return clone;
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{PcapChannelOption.SUPPORT_VLANS, PcapChannelOption.PORT, PcapChannelOption.PROTOCOL_ID, PcapChannelOption.PACKET_HANDLER});
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        if (option == PcapChannelOption.SUPPORT_VLANS) {
            if (value instanceof Boolean) {
                this.supportVlans = (Boolean)value;
                return true;
            }
            return false;
        }
        if (option == PcapChannelOption.PORT) {
            if (value instanceof Integer) {
                this.port = (Integer)value;
                return true;
            }
            return false;
        }
        if (option == PcapChannelOption.PROTOCOL_ID) {
            if (value instanceof Integer) {
                this.protocolId = (Integer)value;
                return true;
            }
            return false;
        }
        if (option == PcapChannelOption.PACKET_HANDLER) {
            if (value instanceof PacketHandler) {
                this.packetHandler = (PacketHandler)value;
                return true;
            }
            return false;
        }
        return super.setOption(option, value);
    }

    public boolean isSupportVlans() {
        return this.supportVlans;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public void setPacketHandler(PacketHandler packetHandler) {
        this.packetHandler = packetHandler;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public String getFilterString(SocketAddress localAddress, SocketAddress remoteAddress) {
        StringBuilder sb = new StringBuilder();
        if (this.isSupportVlans()) {
            PcapChannelConfig clone = this.clone();
            clone.supportVlans = false;
            String subFilterString = clone.getFilterString(localAddress, remoteAddress);
            if (subFilterString.isEmpty()) {
                sb.append(" and (vlan)");
            } else {
                sb.append(" and ((vlan and ").append(subFilterString).append(") or (").append(subFilterString).append("))");
            }
        } else {
            if (this.getProtocolId() != -1) {
                sb.append(" and (ether proto ").append(this.getProtocolId()).append(")");
            }
            if (this.getPort() != -1) {
                sb.append(" and (port ").append(this.getPort()).append(")");
            }
        }
        return sb.length() > 0 ? sb.toString().substring(" and ".length()) : "";
    }
}

