/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock.protocol;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class Plc4XSupportedDataTypes {
    private static final Map<Class, DataTypePair<?>> littleEndianMap = new HashMap();
    private static final Map<Class, DataTypePair<?>> bigEndianMap;

    public static Stream<Class<? extends Serializable>> streamOfPlc4XSupportedDataTypes() {
        return Stream.of(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, BigInteger.class, Float.class, Double.class, BigDecimal.class, String.class, LocalTime.class, LocalDate.class, LocalDateTime.class, byte[].class, Byte[].class);
    }

    public static Stream<? extends DataTypePair<?>> streamOfLittleEndianDataTypePairs() {
        return Plc4XSupportedDataTypes.streamOfLittleEndianDataTypePairs(Plc4XSupportedDataTypes.streamOfPlc4XSupportedDataTypes());
    }

    public static Stream<? extends DataTypePair<?>> streamOfLittleEndianDataTypePairs(Stream<Class<? extends Serializable>> inputStream) {
        return inputStream.map(littleEndianMap::get).peek(Objects::requireNonNull);
    }

    public static Stream<? extends DataTypePair<?>> streamOfBigEndianDataTypePairs() {
        return Plc4XSupportedDataTypes.streamOfBigEndianDataTypePairs(Plc4XSupportedDataTypes.streamOfPlc4XSupportedDataTypes());
    }

    public static Stream<? extends DataTypePair<?>> streamOfBigEndianDataTypePairs(Stream<Class<? extends Serializable>> inputStream) {
        return inputStream.map(bigEndianMap::get).peek(Objects::requireNonNull);
    }

    public static <T> Optional<T> getDefaultForClass(Class<T> clazz) {
        DataTypePair<?> pair = littleEndianMap.get(clazz);
        if (pair == null) {
            return Optional.empty();
        }
        return Optional.of(pair.getValue());
    }

    public static void defaultAssert(Object actualValue) {
        Plc4XSupportedDataTypes.defaultAssert(actualValue, dataTypePair -> dataTypePair);
    }

    public static void defaultAssert(Object actualValue, Function<? super DataTypePair<?>, ? extends DataTypePair<?>> customMapper) {
        littleEndianMap.values().stream().map(customMapper).forEach(pair -> Plc4XSupportedDataTypes.assertPayloadDependentEquals(actualValue, pair.getValue()));
    }

    private static void assertPayloadDependentEquals(Object actual, Object expected) {
        if (actual.getClass() != expected.getClass()) {
            return;
        }
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
    }

    static {
        littleEndianMap.put(Boolean.class, DataTypePair.of(Boolean.TRUE, new byte[]{1}));
        littleEndianMap.put(Byte.class, DataTypePair.of(Byte.valueOf("1"), new byte[]{1}));
        littleEndianMap.put(Short.class, DataTypePair.of(Short.valueOf("1"), new byte[]{1, 0}));
        littleEndianMap.put(Integer.class, DataTypePair.of(Integer.valueOf("1"), new byte[]{1, 0, 0, 0}));
        littleEndianMap.put(Long.class, DataTypePair.of(BigInteger.valueOf(1L), new byte[]{1, 0, 0, 0, 0, 0, 0, 0}));
        littleEndianMap.put(BigInteger.class, DataTypePair.of(BigInteger.valueOf(1L), new byte[]{1, 0, 0, 0, 0, 0, 0, 0}));
        littleEndianMap.put(Float.class, DataTypePair.of(Float.valueOf("1"), new byte[]{0, 0, -128, 63}));
        littleEndianMap.put(Double.class, DataTypePair.of(Double.valueOf("1"), new byte[]{0, 0, 0, 0, 0, 0, -16, 63}));
        littleEndianMap.put(BigDecimal.class, DataTypePair.of(Double.valueOf("1"), new byte[]{0, 0, 0, 0, 0, 0, -16, 63}));
        littleEndianMap.put(String.class, DataTypePair.of(String.valueOf("Hello World!"), new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 33, 0}));
        littleEndianMap.put(LocalTime.class, DataTypePair.of(LocalTime.ofSecondOfDay(1L), new byte[]{1, 0, 0, 0, 0, 0, 0, 0}));
        littleEndianMap.put(LocalDate.class, DataTypePair.of(LocalDate.of(1970, 1, 1), new byte[]{1, 0, 0, 0, 0, 0, 0, 0}));
        littleEndianMap.put(LocalDateTime.class, DataTypePair.of(LocalDateTime.of(LocalDate.of(1970, 1, 1), LocalTime.ofSecondOfDay(1L)), new byte[]{1, 0, 0, 0, 0, 0, 0, 0}));
        littleEndianMap.put(byte[].class, DataTypePair.of(new byte[]{1, 2, 3, 4}, new byte[]{1, 2, 3, 4}));
        littleEndianMap.put(Byte[].class, DataTypePair.of(new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4}, new byte[]{1, 2, 3, 4}));
        bigEndianMap = new HashMap();
        littleEndianMap.forEach((clazz, pair) -> {
            Object serializable = pair.getValue();
            byte[] littleEndianBytes = pair.getByteRepresentation();
            byte[] bigEndianBytes = ArrayUtils.clone((byte[])littleEndianBytes);
            ArrayUtils.reverse((byte[])bigEndianBytes);
            if (clazz == byte[].class || clazz == Byte[].class) {
                ArrayUtils.reverse((byte[])bigEndianBytes);
            }
            bigEndianMap.put((Class)clazz, DataTypePair.of(serializable, bigEndianBytes));
        });
    }

    public static class DataTypePair<T extends Serializable> {
        private final Pair<T, byte[]> dataTypePair;

        public DataTypePair(Pair<T, byte[]> dataTypePair) {
            this.dataTypePair = dataTypePair;
        }

        public static <T extends Serializable> DataTypePair<T> of(T value, byte[] bytes) {
            return new DataTypePair<T>(ImmutablePair.of(value, (Object)bytes));
        }

        public T getValue() {
            return (T)SerializationUtils.clone((Serializable)((Serializable)this.dataTypePair.getLeft()));
        }

        public Class<?> getDataTypeClass() {
            return ((Serializable)this.dataTypePair.getLeft()).getClass();
        }

        public byte[] getByteRepresentation() {
            return ArrayUtils.clone((byte[])((byte[])this.dataTypePair.getRight()));
        }

        public Pair<T, byte[]> getDataTypePair() {
            return this.dataTypePair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataTypePair)) {
                return false;
            }
            DataTypePair that = (DataTypePair)o;
            return Objects.equals(this.dataTypePair, that.dataTypePair);
        }

        public int hashCode() {
            return Objects.hash(this.dataTypePair);
        }

        public String toString() {
            return "DataTypePair{dataTypePair=" + this.dataTypePair + '}';
        }
    }
}

