/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.mock.field.MockPlcValue;
import org.apache.plc4x.java.mock.field.MockType;

public class MockField
implements PlcField {
    private final String address;
    private MockPlcValue plcValue;
    private MockType type;
    private static final Pattern PATTERN = Pattern.compile("%(?<name>[a-zA-Z_.0-9]+(?:\\[[0-9]*])?):?(?<type>[A-Z]*)");

    public static MockField of(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = PATTERN.matcher(addressString);
        if (matcher.matches()) {
            String addr = matcher.group("name");
            MockType type = MockType.valueOf(matcher.group("type"));
            return new MockField(addr, type);
        }
        return null;
    }

    public MockField(String address) {
        this.address = address;
        this.plcValue = null;
    }

    public MockField(String address, MockType type) {
        this.address = address;
        this.type = type;
    }

    public MockField(String address, MockPlcValue plcValue) {
        this.address = address;
        this.plcValue = plcValue;
    }

    public String getAddress() {
        return this.address;
    }

    public MockPlcValue getPlcValue() {
        return this.plcValue;
    }

    public String getPlcDataType() {
        return this.type.toString();
    }

    public String toString() {
        return "mock field: " + this.address;
    }

    public boolean equals(Object o) {
        return o instanceof MockField && ((MockField)o).address.equals(this.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public Class<?> getDefaultJavaType() {
        switch (this.type) {
            case BOOL: {
                return Boolean.class;
            }
            case INT: {
                return Integer.class;
            }
            case REAL: {
                return Double.class;
            }
        }
        return null;
    }
}

