/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.PortSegmentType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PortSegmentExtended
extends PortSegmentType
implements Message {
    protected final byte port;
    protected final short linkAddressSize;
    protected final String address;

    @Override
    public Boolean getExtendedLinkAddress() {
        return true;
    }

    public PortSegmentExtended(byte port, short linkAddressSize, String address) {
        this.port = port;
        this.linkAddressSize = linkAddressSize;
        this.address = address;
    }

    public byte getPort() {
        return this.port;
    }

    public short getLinkAddressSize() {
        return this.linkAddressSize;
    }

    public String getAddress() {
        return this.address;
    }

    public short getPaddingByte() {
        return (short)(this.getLinkAddressSize() % 2);
    }

    @Override
    protected void serializePortSegmentTypeChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PortSegmentExtended", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"port", (Object)this.port, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"linkAddressSize", (Object)this.linkAddressSize, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        short paddingByte = this.getPaddingByte();
        writeBuffer.writeVirtual("paddingByte", (Object)paddingByte, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)(this.linkAddressSize * 8 + paddingByte * 8)), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PortSegmentExtended", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        PortSegmentExtended _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        lengthInBits += 8;
        return lengthInBits += this.getLinkAddressSize() * 8 + this.getPaddingByte() * 8;
    }

    public static PortSegmentType.PortSegmentTypeBuilder staticParsePortSegmentTypeBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("PortSegmentExtended", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte port = (Byte)FieldReaderFactory.readSimpleField((String)"port", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[0]);
        short linkAddressSize = (Short)FieldReaderFactory.readSimpleField((String)"linkAddressSize", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        short paddingByte = (Short)FieldReaderFactory.readVirtualField((String)"paddingByte", Short.TYPE, (Object)(linkAddressSize % 2), (WithReaderArgs[])new WithReaderArgs[0]);
        String address = (String)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)(linkAddressSize * 8 + paddingByte * 8)), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PortSegmentExtended", new WithReaderArgs[0]);
        return new PortSegmentExtendedBuilderImpl(port, linkAddressSize, address);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortSegmentExtended)) {
            return false;
        }
        PortSegmentExtended that = (PortSegmentExtended)o;
        return this.getPort() == that.getPort() && this.getLinkAddressSize() == that.getLinkAddressSize() && this.getAddress() == that.getAddress() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPort(), this.getLinkAddressSize(), this.getAddress());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PortSegmentExtendedBuilderImpl
    implements PortSegmentType.PortSegmentTypeBuilder {
        private final byte port;
        private final short linkAddressSize;
        private final String address;

        public PortSegmentExtendedBuilderImpl(byte port, short linkAddressSize, String address) {
            this.port = port;
            this.linkAddressSize = linkAddressSize;
            this.address = address;
        }

        @Override
        public PortSegmentExtended build() {
            PortSegmentExtended portSegmentExtended = new PortSegmentExtended(this.port, this.linkAddressSize, this.address);
            return portSegmentExtended;
        }
    }
}

