/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CommandSpecificDataItem;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EipListIdentityResponse
extends EipPacket
implements Message {
    protected final List<CommandSpecificDataItem> items;

    @Override
    public Integer getCommand() {
        return 99;
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    @Override
    public Integer getPacketLength() {
        return 0;
    }

    public EipListIdentityResponse(long sessionHandle, long status, byte[] senderContext, long options, List<CommandSpecificDataItem> items) {
        super(sessionHandle, status, senderContext, options);
        this.items = items;
    }

    public List<CommandSpecificDataItem> getItems() {
        return this.items;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EipListIdentityResponse", new WithWriterArgs[0]);
        int itemCount = StaticHelper.COUNT(this.getItems());
        FieldWriterFactory.writeImplicitField((String)"itemCount", (Object)itemCount, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"items", this.items, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EipListIdentityResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EipListIdentityResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.items != null) {
            int i = 0;
            for (CommandSpecificDataItem element : this.items) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.items.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static EipPacket.EipPacketBuilder staticParseEipPacketBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("EipListIdentityResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int itemCount = (Integer)FieldReaderFactory.readImplicitField((String)"itemCount", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        List items = FieldReaderFactory.readCountArrayField((String)"items", (DataReader)new DataReaderComplexDefault(() -> CommandSpecificDataItem.staticParse(readBuffer), readBuffer), (long)itemCount, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("EipListIdentityResponse", new WithReaderArgs[0]);
        return new EipListIdentityResponseBuilderImpl(items);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipListIdentityResponse)) {
            return false;
        }
        EipListIdentityResponse that = (EipListIdentityResponse)o;
        return this.getItems() == that.getItems() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getItems());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EipListIdentityResponseBuilderImpl
    implements EipPacket.EipPacketBuilder {
        private final List<CommandSpecificDataItem> items;

        public EipListIdentityResponseBuilderImpl(List<CommandSpecificDataItem> items) {
            this.items = items;
        }

        @Override
        public EipListIdentityResponse build(long sessionHandle, long status, byte[] senderContext, long options) {
            EipListIdentityResponse eipListIdentityResponse = new EipListIdentityResponse(sessionHandle, status, senderContext, options, this.items);
            return eipListIdentityResponse;
        }
    }
}

