/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.logix;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.eip.base.protocol.EipProtocolLogic;
import org.apache.plc4x.java.eip.base.tag.EipTag;
import org.apache.plc4x.java.eip.base.tag.EipTagHandler;
import org.apache.plc4x.java.eip.logix.configuration.LogixConfiguration;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class LogixDriver
extends GeneratedDriverBase<EipPacket> {
    public String getProtocolCode() {
        return "logix";
    }

    public String getProtocolName() {
        return "Logix CIP";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return LogixConfiguration.class;
    }

    protected PlcTagHandler getTagHandler() {
        return new EipTagHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new org.apache.plc4x.java.spi.values.PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return true;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected ProtocolStackConfigurer<EipPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(EipPacket.class, (readBuffer, objectArray) -> EipPacket.staticParse(readBuffer, objectArray)).withProtocol(EipProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{true}).withCorruptPacketRemover(CorruptPackageCleaner.class).littleEndian().build();
    }

    public EipTag prepareTag(String query) {
        return EipTag.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                int size = byteBuf.getUnsignedShortLE(byteBuf.readerIndex() + 2) + 24;
                return size;
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != 0) {
                byteBuf.readByte();
            }
        }
    }
}

