/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.cache;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.EventPlcConnection;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseRequestInterceptor;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcPingResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.api.model.PlcQuery;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.utils.cache.ConnectionContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeasedPlcConnection
implements EventPlcConnection {
    private static final Logger log = LoggerFactory.getLogger(LeasedPlcConnection.class);
    private final ConnectionContainer connectionContainer;
    private final AtomicReference<PlcConnection> connection;
    private boolean invalidateConnection;
    private final Timer usageTimer;
    private final Duration maxUseDuration;

    LeasedPlcConnection(ConnectionContainer connectionContainer, PlcConnection connection, Duration maxUseTime) {
        this.connectionContainer = connectionContainer;
        this.connection = new AtomicReference<PlcConnection>(connection);
        this.invalidateConnection = false;
        this.usageTimer = new Timer("CC-Usage-Timer-" + Thread.currentThread().getId());
        this.maxUseDuration = maxUseTime;
        this.usageTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                LeasedPlcConnection.this.close();
            }
        }, Date.from(LocalDateTime.now().plusNanos(maxUseTime.toNanos()).atZone(ZoneId.systemDefault()).toInstant()));
    }

    public synchronized void closeConnection() throws Exception {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection != null) {
            plcConnection.close();
        }
        this.close();
    }

    public synchronized void close() {
        if (this.connection.get() == null) {
            return;
        }
        this.usageTimer.cancel();
        this.connection.set(null);
        this.connectionContainer.returnConnection(this, this.invalidateConnection);
    }

    public Optional<PlcTag> parseTagAddress(String tagAddress) {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.parseTagAddress(tagAddress);
    }

    public Optional<PlcValue> parseTagValue(PlcTag tag, Object ... values) {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.parseTagValue(tag, values);
    }

    public void connect() throws PlcConnectionException {
        throw new PlcConnectionException("Error connecting leased connection");
    }

    public boolean isConnected() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.isConnected();
    }

    public PlcConnectionMetadata getMetadata() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.getMetadata();
    }

    public CompletableFuture<? extends PlcPingResponse> ping() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        return plcConnection.ping();
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcReadRequest.Builder innerBuilder = plcConnection.readRequestBuilder();
        return new PlcReadRequest.Builder(){

            public PlcReadRequest build() {
                final PlcReadRequest innerPlcReadRequest = innerBuilder.build();
                return new PlcReadRequest(){

                    public CompletableFuture<? extends PlcReadResponse> execute() {
                        CompletableFuture future = innerPlcReadRequest.execute().orTimeout(Math.min(1000L, (this).LeasedPlcConnection.this.maxUseDuration.toMillis()), TimeUnit.MILLISECONDS);
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcReadResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcReadResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                log.debug("ReadRequest execution completed exceptionally invalidateConnection=true", throwable);
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    public int getNumberOfTags() {
                        return innerPlcReadRequest.getNumberOfTags();
                    }

                    public LinkedHashSet<String> getTagNames() {
                        return innerPlcReadRequest.getTagNames();
                    }

                    public PlcResponseCode getTagResponseCode(String tagName) {
                        return innerPlcReadRequest.getTagResponseCode(tagName);
                    }

                    public PlcTag getTag(String name) {
                        return innerPlcReadRequest.getTag(name);
                    }

                    public List<PlcTag> getTags() {
                        return innerPlcReadRequest.getTags();
                    }
                };
            }

            public PlcReadRequest.Builder addTagAddress(String name, String tagAddress) {
                return innerBuilder.addTagAddress(name, tagAddress);
            }

            public PlcReadRequest.Builder addTag(String name, PlcTag tag) {
                return innerBuilder.addTag(name, tag);
            }
        };
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcWriteRequest.Builder innerBuilder = plcConnection.writeRequestBuilder();
        return new PlcWriteRequest.Builder(){

            public PlcWriteRequest build() {
                final PlcWriteRequest innerPlcWriteRequest = innerBuilder.build();
                return new PlcWriteRequest(){

                    public CompletableFuture<? extends PlcWriteResponse> execute() {
                        CompletableFuture future = innerPlcWriteRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcWriteResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcWriteResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    public int getNumberOfValues(String name) {
                        return innerPlcWriteRequest.getNumberOfValues(name);
                    }

                    public PlcValue getPlcValue(String name) {
                        return innerPlcWriteRequest.getPlcValue(name);
                    }

                    public int getNumberOfTags() {
                        return innerPlcWriteRequest.getNumberOfTags();
                    }

                    public LinkedHashSet<String> getTagNames() {
                        return innerPlcWriteRequest.getTagNames();
                    }

                    public PlcResponseCode getTagResponseCode(String tagName) {
                        return innerPlcWriteRequest.getTagResponseCode(tagName);
                    }

                    public PlcTag getTag(String name) {
                        return innerPlcWriteRequest.getTag(name);
                    }

                    public List<PlcTag> getTags() {
                        return innerPlcWriteRequest.getTags();
                    }
                };
            }

            public PlcWriteRequest.Builder addTagAddress(String name, String tagAddress, Object ... values) {
                return innerBuilder.addTagAddress(name, tagAddress, values);
            }

            public PlcWriteRequest.Builder addTag(String name, PlcTag tag, Object ... values) {
                return innerBuilder.addTag(name, tag, values);
            }
        };
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcSubscriptionRequest.Builder innerBuilder = plcConnection.subscriptionRequestBuilder();
        return new PlcSubscriptionRequest.Builder(){

            public PlcSubscriptionRequest build() {
                final PlcSubscriptionRequest innerPlcSubscriptionRequest = innerBuilder.build();
                return new PlcSubscriptionRequest(){

                    public CompletableFuture<? extends PlcSubscriptionResponse> execute() {
                        CompletableFuture future = innerPlcSubscriptionRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcSubscriptionResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcSubscriptionResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    public int getNumberOfTags() {
                        return innerPlcSubscriptionRequest.getNumberOfTags();
                    }

                    public LinkedHashSet<String> getTagNames() {
                        return innerPlcSubscriptionRequest.getTagNames();
                    }

                    public PlcSubscriptionTag getTag(String name) {
                        return innerPlcSubscriptionRequest.getTag(name);
                    }

                    public PlcResponseCode getTagResponseCode(String tagName) {
                        return innerPlcSubscriptionRequest.getTagResponseCode(tagName);
                    }

                    public List<PlcSubscriptionTag> getTags() {
                        return innerPlcSubscriptionRequest.getTags();
                    }

                    public Consumer<PlcSubscriptionEvent> getConsumer() {
                        return innerPlcSubscriptionRequest.getConsumer();
                    }

                    public Consumer<PlcSubscriptionEvent> getTagConsumer(String name) {
                        return innerPlcSubscriptionRequest.getTagConsumer(name);
                    }
                };
            }

            public PlcSubscriptionRequest.Builder setConsumer(Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.setConsumer(consumer);
            }

            public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval) {
                return innerBuilder.addCyclicTagAddress(name, tagAddress, pollingInterval);
            }

            public PlcSubscriptionRequest.Builder addCyclicTagAddress(String name, String tagAddress, Duration pollingInterval, Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.addCyclicTagAddress(name, tagAddress, pollingInterval, consumer);
            }

            public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval) {
                return innerBuilder.addCyclicTag(name, tag, pollingInterval);
            }

            public PlcSubscriptionRequest.Builder addCyclicTag(String name, PlcTag tag, Duration pollingInterval, Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.addCyclicTag(name, tag, pollingInterval, consumer);
            }

            public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress) {
                return innerBuilder.addChangeOfStateTagAddress(name, tagAddress);
            }

            public PlcSubscriptionRequest.Builder addChangeOfStateTagAddress(String name, String tagAddress, Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.addChangeOfStateTagAddress(name, tagAddress, consumer);
            }

            public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag) {
                return innerBuilder.addChangeOfStateTag(name, tag);
            }

            public PlcSubscriptionRequest.Builder addChangeOfStateTag(String name, PlcTag tag, Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.addChangeOfStateTag(name, tag, consumer);
            }

            public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress) {
                return innerBuilder.addEventTagAddress(name, tagAddress);
            }

            public PlcSubscriptionRequest.Builder addEventTagAddress(String name, String tagAddress, Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.addEventTagAddress(name, tagAddress, consumer);
            }

            public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag) {
                return innerBuilder.addEventTag(name, tag);
            }

            public PlcSubscriptionRequest.Builder addEventTag(String name, PlcTag tag, Consumer<PlcSubscriptionEvent> consumer) {
                return innerBuilder.addEventTag(name, tag, consumer);
            }
        };
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcUnsubscriptionRequest.Builder innerBuilder = plcConnection.unsubscriptionRequestBuilder();
        return new PlcUnsubscriptionRequest.Builder(){

            public PlcUnsubscriptionRequest build() {
                final PlcUnsubscriptionRequest innerPlcUnsubscriptionRequest = innerBuilder.build();
                return new PlcUnsubscriptionRequest(){

                    public CompletableFuture<PlcUnsubscriptionResponse> execute() {
                        CompletableFuture future = innerPlcUnsubscriptionRequest.execute();
                        CompletableFuture<PlcUnsubscriptionResponse> responseFuture = new CompletableFuture<PlcUnsubscriptionResponse>();
                        future.handle((plcUnsubscriptionResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete((PlcUnsubscriptionResponse)plcUnsubscriptionResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    public List<PlcSubscriptionHandle> getSubscriptionHandles() {
                        return innerPlcUnsubscriptionRequest.getSubscriptionHandles();
                    }
                };
            }

            public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle) {
                return innerBuilder.addHandles(plcSubscriptionHandle);
            }

            public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle1, PlcSubscriptionHandle ... plcSubscriptionHandles) {
                return innerBuilder.addHandles(plcSubscriptionHandle1, plcSubscriptionHandles);
            }

            public PlcUnsubscriptionRequest.Builder addHandles(Collection<PlcSubscriptionHandle> plcSubscriptionHandle) {
                return innerBuilder.addHandles(plcSubscriptionHandle);
            }
        };
    }

    public PlcBrowseRequest.Builder browseRequestBuilder() {
        PlcConnection plcConnection = this.connection.get();
        if (plcConnection == null) {
            throw new PlcRuntimeException("Error using leased connection after returning it to the cache.");
        }
        final PlcBrowseRequest.Builder innerBuilder = plcConnection.browseRequestBuilder();
        return new PlcBrowseRequest.Builder(){

            public PlcBrowseRequest build() {
                final PlcBrowseRequest innerPlcBrowseRequest = innerBuilder.build();
                return new PlcBrowseRequest(){

                    public CompletableFuture<? extends PlcBrowseResponse> execute() {
                        CompletableFuture future = innerPlcBrowseRequest.execute();
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcBrowseResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcBrowseResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    public CompletableFuture<? extends PlcBrowseResponse> executeWithInterceptor(PlcBrowseRequestInterceptor interceptor) {
                        CompletableFuture future = innerPlcBrowseRequest.executeWithInterceptor(interceptor);
                        CompletableFuture responseFuture = new CompletableFuture();
                        future.handle((plcBrowseResponse, throwable) -> {
                            if (throwable == null) {
                                responseFuture.complete(plcBrowseResponse);
                            } else {
                                (this).LeasedPlcConnection.this.invalidateConnection = true;
                                responseFuture.completeExceptionally((Throwable)throwable);
                            }
                            return null;
                        });
                        return responseFuture;
                    }

                    public LinkedHashSet<String> getQueryNames() {
                        return innerPlcBrowseRequest.getQueryNames();
                    }

                    public PlcQuery getQuery(String name) {
                        return innerPlcBrowseRequest.getQuery(name);
                    }
                };
            }

            public PlcBrowseRequest.Builder addQuery(String name, String query) {
                return innerBuilder.addQuery(name, query);
            }
        };
    }

    public void addEventListener(EventListener listener) {
        this.connectionContainer.addEventListener(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.connectionContainer.removeEventListener(listener);
    }

    static /* synthetic */ void access$0(LeasedPlcConnection leasedPlcConnection, boolean bl) {
        leasedPlcConnection.invalidateConnection = bl;
    }

    static /* synthetic */ Logger access$1() {
        return log;
    }
}

