/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.cache;

import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.plc4x.java.api.EventPlcConnection;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.utils.cache.LeasedPlcConnection;
import org.apache.plc4x.java.utils.cache.exceptions.PlcConnectionManagerClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionContainer.class);
    private final PlcConnectionManager connectionManager;
    private final String connectionUrl;
    private final Duration maxLeaseTime;
    private final Duration maxIdleTime;
    private final Function<String, Void> closeConnectionHandler;
    private final Queue<CompletableFuture<PlcConnection>> queue;
    private PlcConnection connection;
    private LeasedPlcConnection leasedConnection;
    private Timer idleTimer;

    public ConnectionContainer(PlcConnectionManager connectionManager, String connectionUrl, Duration maxLeaseTime, Duration maxIdleTime, Function<String, Void> closeConnectionHandler) {
        this.connectionManager = connectionManager;
        this.connectionUrl = connectionUrl;
        this.maxLeaseTime = maxLeaseTime;
        this.maxIdleTime = maxIdleTime;
        this.closeConnectionHandler = closeConnectionHandler;
        this.queue = new LinkedList<CompletableFuture<PlcConnection>>();
        this.connection = null;
        this.leasedConnection = null;
    }

    public synchronized void close() {
        this.queue.forEach(plcConnectionCompletableFuture -> {
            boolean bl = plcConnectionCompletableFuture.completeExceptionally((Throwable)((Object)new PlcConnectionManagerClosedException()));
        });
        this.queue.clear();
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer.purge();
        }
        if (this.leasedConnection != null) {
            try {
                this.leasedConnection.closeConnection();
                this.leasedConnection = null;
            }
            catch (Exception exception) {}
        } else {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized Future<PlcConnection> lease() {
        CompletableFuture<PlcConnection> connectionFuture = new CompletableFuture<PlcConnection>();
        if (this.connection == null) {
            try {
                this.connection = this.connectionManager.getConnection(this.connectionUrl);
            }
            catch (PlcConnectionException e) {
                LOGGER.warn("Exception while getting connection for lease", (Throwable)e);
                connectionFuture.completeExceptionally(e);
                return connectionFuture;
            }
        }
        if (this.leasedConnection == null) {
            this.leasedConnection = new LeasedPlcConnection(this, this.connection, this.maxLeaseTime);
            connectionFuture.complete((PlcConnection)this.leasedConnection);
        } else {
            this.queue.add(connectionFuture);
        }
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer.purge();
        }
        return connectionFuture;
    }

    public synchronized void returnConnection(LeasedPlcConnection returnedLeasedConnection, boolean invalidateConnection) {
        if (returnedLeasedConnection != this.leasedConnection) {
            LOGGER.error("Error trying to return lease from invalid connection: returned={} leased={}", (Object)returnedLeasedConnection, (Object)this.leasedConnection);
            throw new PlcRuntimeException("Error trying to return lease from invalid connection");
        }
        if (invalidateConnection) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                LOGGER.warn("Exception while closing connection", (Throwable)e);
            }
            try {
                this.connection = this.connectionManager.getConnection(this.connectionUrl);
            }
            catch (PlcConnectionException e) {
                LOGGER.warn("Can't get connection for {} complete queue items exceptionally", (Object)this.connectionUrl, (Object)e);
                this.queue.forEach(future -> {
                    boolean bl = future.completeExceptionally(e);
                });
                this.connection = null;
            }
        }
        if (this.queue.isEmpty()) {
            this.leasedConnection = null;
            this.idleTimer = new Timer("CC-Idle-Timer-" + Thread.currentThread().getId());
            this.idleTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (ConnectionContainer.this.connection != null) {
                        try {
                            ConnectionContainer.this.connection.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ConnectionContainer.this.closeConnectionHandler.apply(ConnectionContainer.this.connectionUrl);
                }
            }, this.maxIdleTime.toMillis());
            return;
        }
        this.leasedConnection = new LeasedPlcConnection(this, this.connection, this.maxLeaseTime);
        CompletableFuture<PlcConnection> leaseFuture = this.queue.poll();
        if (leaseFuture != null) {
            leaseFuture.complete((PlcConnection)this.leasedConnection);
        }
    }

    public void addEventListener(EventListener listener) {
        if (this.connection != null && this.connection instanceof EventPlcConnection) {
            ((EventPlcConnection)this.connection).addEventListener(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (this.connection != null && this.connection instanceof EventPlcConnection) {
            ((EventPlcConnection)this.connection).removeEventListener(listener);
        }
    }
}

