/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.series;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.series.TimeSeries;

public abstract class BaseTimeSeriesBuilder {
    protected final String _id;
    @Nullable
    protected final Long[] _timeValues;
    @Nullable
    protected final TimeBuckets _timeBuckets;
    protected final List<String> _tagNames;
    protected final Object[] _tagValues;

    public BaseTimeSeriesBuilder(String id, @Nullable Long[] timeValues, @Nullable TimeBuckets timeBuckets, List<String> tagNames, Object[] tagValues) {
        this._id = id;
        this._timeValues = timeValues;
        this._timeBuckets = timeBuckets;
        this._tagNames = tagNames;
        this._tagValues = tagValues;
    }

    public abstract void addValueAtIndex(int var1, Double var2);

    public void addValueAtIndex(int timeBucketIndex, String value) {
        throw new IllegalStateException("This aggregation function does not support string input");
    }

    public abstract void addValue(long var1, Double var3);

    public void mergeAlignedSeries(TimeSeries series) {
        int numDataPoints = series.getDoubleValues().length;
        for (int i = 0; i < numDataPoints; ++i) {
            this.addValueAtIndex(i, series.getDoubleValues()[i]);
        }
    }

    public void mergeAlignedSeriesBuilder(BaseTimeSeriesBuilder builder) {
        TimeSeries timeSeries = builder.build();
        this.mergeAlignedSeries(timeSeries);
    }

    public abstract TimeSeries build();
}

