/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.data.TimeGranularitySpec;

public class TimeConverter {
    private final TimeGranularitySpec _timeGranularitySpec;

    public TimeConverter(TimeGranularitySpec timeGranularitySpec) {
        Preconditions.checkArgument((boolean)timeGranularitySpec.getTimeFormat().equals(TimeGranularitySpec.TimeFormat.EPOCH.toString()), (Object)"Cannot perform time conversion for time format other than EPOCH");
        this._timeGranularitySpec = timeGranularitySpec;
    }

    public long toMillisSinceEpoch(Object value) {
        long duration = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
        return this._timeGranularitySpec.getTimeType().toMillis(duration * (long)this._timeGranularitySpec.getTimeUnitSize());
    }

    public Object fromMillisSinceEpoch(long value) {
        long duration = this._timeGranularitySpec.getTimeType().convert(value, TimeUnit.MILLISECONDS) / (long)this._timeGranularitySpec.getTimeUnitSize();
        switch (this._timeGranularitySpec.getDataType()) {
            case INT: {
                return (int)duration;
            }
            case LONG: {
                return duration;
            }
            case FLOAT: {
                return Float.valueOf(duration);
            }
            case DOUBLE: {
                return (double)duration;
            }
            case STRING: {
                return Long.toString(duration);
            }
        }
        throw new IllegalStateException();
    }
}

