/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.trace;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.spi.accounting.ThreadAccountantFactory;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageAccountant;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.NoOpRecording;
import org.apache.pinot.spi.trace.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tracing.class);
    private static final AtomicReference<Tracer> TRACER_REGISTRATION = new AtomicReference();
    private static final AtomicReference<ThreadResourceUsageAccountant> ACCOUNTANT_REGISTRATION = new AtomicReference();

    private Tracing() {
    }

    public static boolean register(Tracer tracer) {
        return TRACER_REGISTRATION.compareAndSet(null, tracer);
    }

    public static boolean register(ThreadResourceUsageAccountant threadResourceUsageAccountant) {
        return ACCOUNTANT_REGISTRATION.compareAndSet(null, threadResourceUsageAccountant);
    }

    public static Tracer getTracer() {
        return Holder.TRACER;
    }

    public static ThreadResourceUsageAccountant getThreadAccountant() {
        return Holder.ACCOUNTANT;
    }

    public static InvocationRecording activeRecording() {
        return Tracing.getTracer().activeRecording();
    }

    private static Tracer createDefaultTracer() {
        String defaultImplementationClassName = "org.apache.pinot.core.util.trace.BuiltInTracer";
        try {
            Class<?> clazz = Class.forName(defaultImplementationClassName, false, Tracing.class.getClassLoader());
            return MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable missing) {
            return FallbackTracer.INSTANCE;
        }
    }

    private static DefaultThreadResourceUsageAccountant createDefaultThreadAccountant() {
        LOGGER.info("Using default thread accountant");
        return new DefaultThreadResourceUsageAccountant();
    }

    public static class ThreadAccountantOps {
        private ThreadAccountantOps() {
        }

        public static void setupRunner(String queryId) {
            Tracing.getThreadAccountant().setThreadResourceUsageProvider(new ThreadResourceUsageProvider());
            Tracing.getThreadAccountant().createExecutionContext(queryId, -1, null);
        }

        public static void setupWorker(int taskId, ThreadResourceUsageProvider threadResourceUsageProvider, ThreadExecutionContext threadExecutionContext) {
            Tracing.getThreadAccountant().setThreadResourceUsageProvider(threadResourceUsageProvider);
            Tracing.getThreadAccountant().createExecutionContext(null, taskId, threadExecutionContext);
        }

        public static void sample() {
            Tracing.getThreadAccountant().sampleUsage();
        }

        public static void clear() {
            Tracing.getThreadAccountant().clear();
        }

        public static void initializeThreadAccountant(int numPqr, int numPqw, PinotConfiguration config) {
            String factoryName = config.getProperty("accounting.factory.name");
            LOGGER.info("Config-specified accountant factory name {}", (Object)factoryName);
            try {
                ThreadAccountantFactory threadAccountantFactory = (ThreadAccountantFactory)Class.forName(factoryName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                boolean registered = Tracing.register(threadAccountantFactory.init(numPqr, numPqw, config));
                LOGGER.info("Using accountant provided by {}", (Object)factoryName);
                if (!registered) {
                    LOGGER.warn("ThreadAccountant {} register unsuccessful, as it is already registered.", (Object)factoryName);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Using default implementation of thread accountant, due to invalid thread accountant factory {} provided.", (Object)factoryName);
            }
            Tracing.getThreadAccountant().startWatcherTask();
        }

        public static boolean isInterrupted() {
            return Thread.interrupted() || Tracing.getThreadAccountant().isAnchorThreadInterrupted();
        }
    }

    public static class DefaultThreadResourceUsageAccountant
    implements ThreadResourceUsageAccountant {
        private final ThreadLocal<Thread> _anchorThread = new ThreadLocal();

        @Override
        public boolean isAnchorThreadInterrupted() {
            Thread thread = this._anchorThread.get();
            return thread != null && thread.isInterrupted();
        }

        @Override
        public void clear() {
            this._anchorThread.set(null);
        }

        @Override
        public void setThreadResourceUsageProvider(ThreadResourceUsageProvider threadResourceUsageProvider) {
        }

        @Override
        public void sampleUsage() {
        }

        @Override
        public final void createExecutionContext(String queryId, int taskId, ThreadExecutionContext parentContext) {
            this._anchorThread.set(parentContext == null ? Thread.currentThread() : parentContext.getAnchorThread());
            this.createExecutionContextInner(queryId, taskId, parentContext);
        }

        public void createExecutionContextInner(String queryId, int taskId, ThreadExecutionContext parentContext) {
        }

        @Override
        public ThreadExecutionContext getThreadExecutionContext() {
            return new ThreadExecutionContext(){

                @Override
                public String getQueryId() {
                    return null;
                }

                @Override
                public Thread getAnchorThread() {
                    return _anchorThread.get();
                }
            };
        }

        @Override
        public void startWatcherTask() {
        }

        @Override
        public Exception getErrorStatus() {
            return null;
        }
    }

    private static final class FallbackTracer
    implements Tracer {
        static final FallbackTracer INSTANCE = new FallbackTracer();

        private FallbackTracer() {
        }

        @Override
        public void register(long requestId) {
        }

        @Override
        public void unregister() {
        }

        @Override
        public InvocationScope createScope(Class<?> clazz) {
            return NoOpRecording.INSTANCE;
        }

        @Override
        public InvocationRecording activeRecording() {
            return NoOpRecording.INSTANCE;
        }
    }

    private static final class Holder {
        static final Tracer TRACER = TRACER_REGISTRATION.get() == null ? Tracing.createDefaultTracer() : TRACER_REGISTRATION.get();
        static final ThreadResourceUsageAccountant ACCOUNTANT = ACCOUNTANT_REGISTRATION.get() == null ? Tracing.createDefaultThreadAccountant() : ACCOUNTANT_REGISTRATION.get();

        private Holder() {
        }
    }
}

