/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionLevelStreamConfig
extends StreamConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionLevelStreamConfig.class);

    public PartitionLevelStreamConfig(String tableNameWithType, Map<String, String> streamConfigMap) {
        super(tableNameWithType, streamConfigMap);
    }

    @Override
    protected int extractFlushThresholdRows(Map<String, String> streamConfigMap) {
        String flushThresholdRowsKey = "realtime.segment.flush.threshold.size.llc";
        String flushThresholdRowsStr = streamConfigMap.get(flushThresholdRowsKey);
        if (flushThresholdRowsStr != null) {
            try {
                int flushThresholdRows = Integer.parseInt(flushThresholdRowsStr);
                Preconditions.checkState((flushThresholdRows >= 0 ? 1 : 0) != 0);
                return flushThresholdRows;
            }
            catch (Exception e) {
                int defaultValue = super.extractFlushThresholdRows(streamConfigMap);
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{flushThresholdRowsKey, flushThresholdRowsStr, defaultValue});
                return defaultValue;
            }
        }
        return super.extractFlushThresholdRows(streamConfigMap);
    }

    @Override
    protected long extractFlushThresholdTimeMillis(Map<String, String> streamConfigMap) {
        String flushThresholdTimeKey = "realtime.segment.flush.threshold.time.llc";
        String flushThresholdTimeStr = streamConfigMap.get(flushThresholdTimeKey);
        if (flushThresholdTimeStr != null) {
            try {
                return TimeUtils.convertPeriodToMillis(flushThresholdTimeStr);
            }
            catch (Exception e) {
                long defaultValue = super.extractFlushThresholdTimeMillis(streamConfigMap);
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{flushThresholdTimeKey, flushThresholdTimeStr, defaultValue});
                return defaultValue;
            }
        }
        return super.extractFlushThresholdTimeMillis(streamConfigMap);
    }
}

