/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pinot.spi.annotations.metrics.MetricsFactory;
import org.apache.pinot.spi.annotations.metrics.PinotMetricsFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.metrics.JmxReporterMetricsRegistryRegistrationListener;
import org.apache.pinot.spi.metrics.MetricsRegistryRegistrationListener;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotJmxReporter;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotTimer;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotMetricUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotMetricUtils.class);
    private static final String METRICS_PACKAGE_REGEX_PATTERN = ".*\\.plugin\\.metrics\\..*";
    private static final Map<PinotMetricsRegistry, Boolean> METRICS_REGISTRY_MAP = new ConcurrentHashMap<PinotMetricsRegistry, Boolean>();
    private static final Map<MetricsRegistryRegistrationListener, Boolean> METRICS_REGISTRY_REGISTRATION_LISTENERS_MAP = new ConcurrentHashMap<MetricsRegistryRegistrationListener, Boolean>();
    private static PinotMetricsFactory _pinotMetricsFactory = null;

    private PinotMetricUtils() {
    }

    @VisibleForTesting
    public static synchronized void init(PinotConfiguration metricsConfiguration) {
        PinotMetricUtils.initializePinotMetricsFactory(metricsConfiguration);
        PinotMetricUtils.initializeMetrics(metricsConfiguration);
        PinotMetricUtils.registerMetricsRegistry(PinotMetricUtils.getPinotMetricsRegistry());
    }

    private static void initializePinotMetricsFactory(PinotConfiguration metricsConfiguration) {
        Set<Class<?>> classes = PinotMetricUtils.getPinotMetricsFactoryClasses();
        if (classes.size() > 1) {
            LOGGER.warn("More than one PinotMetricsFactory was found: {}", classes);
        }
        String metricsFactoryClassName = metricsConfiguration.getProperty("factory.className", "org.apache.pinot.plugin.metrics.yammer.YammerMetricsFactory");
        LOGGER.info("{} will be initialized as the PinotMetricsFactory", (Object)metricsFactoryClassName);
        Optional<Class> clazzFound = classes.stream().filter(c -> c.getName().equals(metricsFactoryClassName)).findFirst();
        clazzFound.ifPresent(clazz -> {
            MetricsFactory annotation = clazz.getAnnotation(MetricsFactory.class);
            LOGGER.info("Trying to init PinotMetricsFactory: {} and MetricsFactory: {}", clazz, (Object)annotation);
            if (annotation.enabled()) {
                try {
                    PinotMetricsFactory pinotMetricsFactory = (PinotMetricsFactory)clazz.newInstance();
                    pinotMetricsFactory.init(metricsConfiguration);
                    PinotMetricUtils.registerMetricsFactory(pinotMetricsFactory);
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while initializing pinot metrics registry: {}, skipping it", clazz, (Object)e);
                }
            }
        });
        Preconditions.checkState((_pinotMetricsFactory != null ? 1 : 0) != 0, (Object)"Failed to initialize PinotMetricsFactory. Please check if any pinot-metrics related jar is actually added to the classpath.");
    }

    private static Set<Class<?>> getPinotMetricsFactoryClasses() {
        return PinotReflectionUtils.getClassesThroughReflection(METRICS_PACKAGE_REGEX_PATTERN, MetricsFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeMetrics(PinotConfiguration configuration) {
        Class<PinotMetricUtils> clazz = PinotMetricUtils.class;
        synchronized (PinotMetricUtils.class) {
            List<String> listenerClassNames = configuration.getProperty("metricsRegistryRegistrationListeners", Arrays.asList(JmxReporterMetricsRegistryRegistrationListener.class.getName()));
            for (String listenerClassName : listenerClassNames) {
                try {
                    Class<?> clazz2 = Class.forName(listenerClassName);
                    Constructor<?> defaultConstructor = clazz2.getDeclaredConstructor(new Class[0]);
                    MetricsRegistryRegistrationListener listener = (MetricsRegistryRegistrationListener)defaultConstructor.newInstance(new Object[0]);
                    LOGGER.info("Registering metricsRegistry to listener {}", (Object)listenerClassName);
                    PinotMetricUtils.addMetricsRegistryRegistrationListener(listener);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception while initializing MetricsRegistryRegistrationListener " + listenerClassName, (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOGGER.info("Number of listeners got registered: {}", (Object)METRICS_REGISTRY_REGISTRATION_LISTENERS_MAP.size());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMetricsRegistryRegistrationListener(MetricsRegistryRegistrationListener listener) {
        Class<PinotMetricUtils> clazz = PinotMetricUtils.class;
        synchronized (PinotMetricUtils.class) {
            METRICS_REGISTRY_REGISTRATION_LISTENERS_MAP.put(listener, Boolean.TRUE);
            Set<PinotMetricsRegistry> metricsRegistries = METRICS_REGISTRY_MAP.keySet();
            LOGGER.info("Number of metrics registry: {}", (Object)metricsRegistries.size());
            for (PinotMetricsRegistry metricsRegistry : metricsRegistries) {
                listener.onMetricsRegistryRegistered(metricsRegistry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerMetricsRegistry(PinotMetricsRegistry registry) {
        Class<PinotMetricUtils> clazz = PinotMetricUtils.class;
        synchronized (PinotMetricUtils.class) {
            METRICS_REGISTRY_MAP.put(registry, Boolean.TRUE);
            Set<MetricsRegistryRegistrationListener> metricsRegistryRegistrationListeners = METRICS_REGISTRY_REGISTRATION_LISTENERS_MAP.keySet();
            for (MetricsRegistryRegistrationListener metricsRegistryRegistrationListener : metricsRegistryRegistrationListeners) {
                metricsRegistryRegistrationListener.onMetricsRegistryRegistered(registry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void registerMetricsFactory(PinotMetricsFactory metricsFactory) {
        LOGGER.info("Registering metrics factory: {}", (Object)metricsFactory.getMetricsFactoryName());
        _pinotMetricsFactory = metricsFactory;
    }

    @VisibleForTesting
    public static PinotMetricsRegistry getPinotMetricsRegistry() {
        return PinotMetricUtils.getPinotMetricsRegistry(new PinotConfiguration(Collections.emptyMap()));
    }

    public static synchronized PinotMetricsRegistry getPinotMetricsRegistry(PinotConfiguration metricsConfiguration) {
        if (_pinotMetricsFactory == null) {
            PinotMetricUtils.init(metricsConfiguration);
        }
        return _pinotMetricsFactory.getPinotMetricsRegistry();
    }

    public static PinotMetricName makePinotMetricName(Class<?> klass, String name) {
        return _pinotMetricsFactory.makePinotMetricName(klass, name);
    }

    public static <T> PinotGauge<T> makePinotGauge(Function<Void, T> condition) {
        return _pinotMetricsFactory.makePinotGauge(condition);
    }

    public static <T> PinotGauge<T> makeGauge(PinotMetricsRegistry registry, PinotMetricName name, PinotGauge<T> gauge) {
        return registry.newGauge(name, gauge);
    }

    public static PinotTimer makePinotTimer(PinotMetricsRegistry registry, PinotMetricName name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return registry.newTimer(name, durationUnit, rateUnit);
    }

    public static PinotMeter makePinotMeter(PinotMetricsRegistry registry, PinotMetricName name, String eventType, TimeUnit unit) {
        return registry.newMeter(name, eventType, unit);
    }

    public static void removeMetric(PinotMetricsRegistry registry, PinotMetricName name) {
        registry.removeMetric(name);
    }

    public static PinotJmxReporter makePinotJmxReporter(PinotMetricsRegistry metricsRegistry) {
        return _pinotMetricsFactory.makePinotJmxReporter(metricsRegistry);
    }
}

