/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.environmentprovider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.environmentprovider.PinotEnvironmentProvider;
import org.apache.pinot.spi.plugin.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotEnvironmentProviderFactory {
    private static final PinotEnvironmentProviderFactory INSTANCE = new PinotEnvironmentProviderFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotEnvironmentProviderFactory.class);
    private static final String CLASS = "class";
    private PinotEnvironmentProvider _pinotEnvironmentProvider;

    private PinotEnvironmentProviderFactory() {
    }

    public static PinotEnvironmentProviderFactory getInstance() {
        return INSTANCE;
    }

    public static void init(PinotConfiguration environmentProviderFactoryConfig) {
        PinotEnvironmentProviderFactory.getInstance().initInternal(environmentProviderFactoryConfig);
    }

    public static PinotEnvironmentProvider getEnvironmentProvider(String environment) {
        return PinotEnvironmentProviderFactory.getInstance().getEnvironmentProviderInternal(environment);
    }

    private void initInternal(PinotConfiguration environmentProviderFactoryConfig) {
        PinotConfiguration environmentConfiguration = environmentProviderFactoryConfig.subset(CLASS);
        List<String> environments = environmentConfiguration.getKeys();
        if (environments.isEmpty()) {
            LOGGER.info("Did not find any environment provider classes in the configuration");
            return;
        }
        String environment = (String)Iterables.getOnlyElement(environments);
        String environmentProviderClassName = environmentConfiguration.getProperty(environment);
        PinotConfiguration environmentProviderConfiguration = environmentProviderFactoryConfig.subset(environment);
        LOGGER.info("Got environment {}, initializing class {}", (Object)environment, (Object)environmentProviderClassName);
        this.register(environment, environmentProviderClassName, environmentProviderConfiguration);
    }

    private PinotEnvironmentProvider getEnvironmentProviderInternal(String environment) {
        Preconditions.checkState((this._pinotEnvironmentProvider != null ? 1 : 0) != 0, (String)"PinotEnvironmentProvider for environment: %s has not been initialized", (Object)environment);
        return this._pinotEnvironmentProvider;
    }

    private void register(String environment, String environmentProviderClassName, PinotConfiguration environmentProviderConfiguration) {
        try {
            LOGGER.info("Initializing PinotEnvironmentProvider for environment {}, classname {}", (Object)environment, (Object)environmentProviderClassName);
            this._pinotEnvironmentProvider = (PinotEnvironmentProvider)PluginManager.get().createInstance(environmentProviderClassName);
            this._pinotEnvironmentProvider.init(environmentProviderConfiguration);
        }
        catch (Exception ex) {
            LOGGER.error("Could not instantiate environment provider for class {} with environment {}", new Object[]{environmentProviderClassName, environment, ex});
            throw new RuntimeException(ex);
        }
    }
}

