/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.EnumUtils;
import org.joda.time.Chronology;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.ISOChronology;

public class DateTimeFormatUnitSpec {
    public static final DateTimeFormatUnitSpec MILLISECONDS = new DateTimeFormatUnitSpec(TimeUnit.MILLISECONDS.name());
    private final TimeUnit _timeUnit;
    private final DateTimeTransformUnit _dateTimeTransformUnit;

    public DateTimeFormatUnitSpec(String unit) {
        this._timeUnit = EnumUtils.isValidEnum(TimeUnit.class, (String)unit) ? TimeUnit.valueOf(unit) : null;
        this._dateTimeTransformUnit = EnumUtils.isValidEnum(DateTimeTransformUnit.class, (String)unit) ? DateTimeTransformUnit.valueOf(unit) : null;
        Preconditions.checkArgument((this._timeUnit != null || this._dateTimeTransformUnit != null ? 1 : 0) != 0, (String)"Unit must belong to enum TimeUnit or DateTimeTransformUnit, got: %s", (Object)unit);
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public DateTimeTransformUnit getDateTimeTransformUnit() {
        return this._dateTimeTransformUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeFormatUnitSpec that = (DateTimeFormatUnitSpec)o;
        return this._timeUnit == that._timeUnit && this._dateTimeTransformUnit == that._dateTimeTransformUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._timeUnit, this._dateTimeTransformUnit});
    }

    public static enum DateTimeTransformUnit {
        MILLISECONDS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return millisSinceEpoch;
            }
        }
        ,
        SECONDS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toSeconds(millisSinceEpoch);
            }
        }
        ,
        MINUTES{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toMinutes(millisSinceEpoch);
            }
        }
        ,
        HOURS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toHours(millisSinceEpoch);
            }
        }
        ,
        DAYS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toDays(millisSinceEpoch);
            }
        }
        ,
        WEEKS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.weeks().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        }
        ,
        MONTHS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.months().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        }
        ,
        YEARS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.years().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        };


        public abstract long fromMillis(long var1);
    }
}

