/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table.assignment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceConstraintConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceReplicaGroupPartitionConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceTagPoolConfig;

public class InstanceAssignmentConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Configuration for the strategy to assign instances to partitions")
    private final PartitionSelector _partitionSelector;
    @JsonPropertyDescription(value="Configuration for the instance tag and pool of the instance assignment (mandatory)")
    private final InstanceTagPoolConfig _tagPoolConfig;
    @JsonPropertyDescription(value="Configuration for the instance constraints of the instance assignment, which filters out unqualified instances and sorts instances for picking priority")
    private final InstanceConstraintConfig _constraintConfig;
    @JsonPropertyDescription(value="Configuration for the instance replica-group and partition of the instance assignment (mandatory)")
    private final InstanceReplicaGroupPartitionConfig _replicaGroupPartitionConfig;

    @JsonCreator
    public InstanceAssignmentConfig(@JsonProperty(value="tagPoolConfig", required=true) InstanceTagPoolConfig tagPoolConfig, @JsonProperty(value="constraintConfig") @Nullable InstanceConstraintConfig constraintConfig, @JsonProperty(value="replicaGroupPartitionConfig", required=true) InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig, @JsonProperty(value="partitionSelector") @Nullable String partitionSelector) {
        Preconditions.checkArgument((tagPoolConfig != null ? 1 : 0) != 0, (Object)"'tagPoolConfig' must be configured");
        Preconditions.checkArgument((replicaGroupPartitionConfig != null ? 1 : 0) != 0, (Object)"'replicaGroupPartitionConfig' must be configured");
        this._tagPoolConfig = tagPoolConfig;
        this._constraintConfig = constraintConfig;
        this._replicaGroupPartitionConfig = replicaGroupPartitionConfig;
        this._partitionSelector = partitionSelector == null ? PartitionSelector.INSTANCE_REPLICA_GROUP_PARTITION_SELECTOR : PartitionSelector.valueOf(partitionSelector);
    }

    public InstanceAssignmentConfig(InstanceTagPoolConfig tagPoolConfig, InstanceConstraintConfig constraintConfig, InstanceReplicaGroupPartitionConfig replicaGroupPartitionConfig) {
        this(tagPoolConfig, constraintConfig, replicaGroupPartitionConfig, null);
    }

    public PartitionSelector getPartitionSelector() {
        return this._partitionSelector;
    }

    public InstanceTagPoolConfig getTagPoolConfig() {
        return this._tagPoolConfig;
    }

    @Nullable
    public InstanceConstraintConfig getConstraintConfig() {
        return this._constraintConfig;
    }

    public InstanceReplicaGroupPartitionConfig getReplicaGroupPartitionConfig() {
        return this._replicaGroupPartitionConfig;
    }

    public static enum PartitionSelector {
        FD_AWARE_INSTANCE_PARTITION_SELECTOR,
        INSTANCE_REPLICA_GROUP_PARTITION_SELECTOR;

    }
}

