/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.TimestampConfig;

public class FieldConfig
extends BaseJsonConfig {
    public static final String BLOOM_FILTER_COLUMN_KEY = "createBloomFilter";
    public static final String ON_HEAP_DICTIONARY_COLUMN_KEY = "useOnHeapDictionary";
    public static final String VAR_LENGTH_DICTIONARY_COLUMN_KEY = "useVarLengthDictionary";
    public static final String DERIVE_NUM_DOCS_PER_CHUNK_RAW_INDEX_KEY = "deriveNumDocsPerChunkForRawIndex";
    public static final String RAW_INDEX_WRITER_VERSION = "rawIndexWriterVersion";
    public static final String IS_SEGMENT_PARTITIONED_COLUMN_KEY = "isSegmentPartitioned";
    public static final String TEXT_INDEX_REALTIME_READER_REFRESH_KEY = "textIndexRealtimeReaderRefreshThreshold";
    public static final String TEXT_INDEX_ENABLE_QUERY_CACHE = "enableQueryCacheForTextIndex";
    public static final String TEXT_INDEX_USE_AND_FOR_MULTI_TERM_QUERIES = "useANDForMultiTermTextIndexQueries";
    public static final String TEXT_INDEX_NO_RAW_DATA = "noRawDataForTextIndex";
    public static final String TEXT_INDEX_RAW_VALUE = "rawValueForTextIndex";
    public static final String TEXT_INDEX_DEFAULT_RAW_VALUE = "n";
    public static final String TEXT_INDEX_STOP_WORD_INCLUDE_KEY = "stopWordInclude";
    public static final String TEXT_INDEX_STOP_WORD_EXCLUDE_KEY = "stopWordExclude";
    public static final String TEXT_INDEX_STOP_WORD_SEPERATOR = ",";
    public static final String TEXT_FST_TYPE = "fstType";
    public static final String TEXT_NATIVE_FST_LITERAL = "native";
    public static final String FORWARD_INDEX_DISABLED = "forwardIndexDisabled";
    public static final String DEFAULT_FORWARD_INDEX_DISABLED = Boolean.FALSE.toString();
    private final String _name;
    private final EncodingType _encodingType;
    private final List<IndexType> _indexTypes;
    private final CompressionCodec _compressionCodec;
    private final Map<String, String> _properties;
    private final TimestampConfig _timestampConfig;

    @Deprecated
    public FieldConfig(String name, EncodingType encodingType, IndexType indexType, CompressionCodec compressionCodec, Map<String, String> properties) {
        this(name, encodingType, indexType, null, compressionCodec, null, properties);
    }

    public FieldConfig(String name, EncodingType encodingType, List<IndexType> indexTypes, CompressionCodec compressionCodec, Map<String, String> properties) {
        this(name, encodingType, null, indexTypes, compressionCodec, null, properties);
    }

    @JsonCreator
    public FieldConfig(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="encodingType") EncodingType encodingType, @JsonProperty(value="indexType") @Nullable IndexType indexType, @JsonProperty(value="indexTypes") @Nullable List<IndexType> indexTypes, @JsonProperty(value="compressionCodec") @Nullable CompressionCodec compressionCodec, @JsonProperty(value="timestampConfig") @Nullable TimestampConfig timestampConfig, @JsonProperty(value="properties") @Nullable Map<String, String> properties) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"'name' must be configured");
        this._name = name;
        this._encodingType = encodingType;
        this._indexTypes = indexTypes != null ? indexTypes : (indexType == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new IndexType[]{indexType}));
        this._compressionCodec = compressionCodec;
        this._timestampConfig = timestampConfig;
        this._properties = properties;
    }

    public String getName() {
        return this._name;
    }

    public EncodingType getEncodingType() {
        return this._encodingType;
    }

    @Nullable
    @Deprecated
    public IndexType getIndexType() {
        return this._indexTypes.size() > 0 ? this._indexTypes.get(0) : null;
    }

    public List<IndexType> getIndexTypes() {
        return this._indexTypes;
    }

    @Nullable
    public CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    @Nullable
    public TimestampConfig getTimestampConfig() {
        return this._timestampConfig;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this._properties;
    }

    public static enum CompressionCodec {
        PASS_THROUGH,
        SNAPPY,
        ZSTANDARD,
        LZ4;

    }

    public static enum IndexType {
        INVERTED,
        SORTED,
        TEXT,
        FST,
        H3,
        JSON,
        TIMESTAMP,
        RANGE;

    }

    public static enum EncodingType {
        RAW,
        DICTIONARY;

    }
}

