/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory.unsafe;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.memory.ByteBufferUtil;
import org.apache.pinot.segment.spi.memory.NonNativePinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.unsafe.Memory;
import org.apache.pinot.segment.spi.memory.unsafe.Unsafer;

public class UnsafePinotBuffer
extends PinotDataBuffer {
    private final long _address;
    private final long _size;
    private final Memory _memory;

    public UnsafePinotBuffer(Memory memory, boolean ownsMemory) {
        this(memory, ownsMemory, memory.getAddress(), memory.getSize());
    }

    private UnsafePinotBuffer(Memory memory, boolean ownsMemory, long address, long size) {
        super(ownsMemory);
        this._memory = memory;
        this._size = size;
        this._address = address;
    }

    void checkOffset(long offset, long size) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset is " + offset);
        }
        if (offset + size > this._size) {
            throw new IllegalArgumentException("Cannot apply a " + size + " byte length operation in offset " + offset);
        }
    }

    @Override
    public byte getByte(long offset) {
        this.checkOffset(offset, 1L);
        return Unsafer.UNSAFE.getByte(this._address + offset);
    }

    @Override
    public void putByte(long offset, byte value) {
        this.checkOffset(offset, 1L);
        Unsafer.UNSAFE.putByte(this._address + offset, value);
    }

    @Override
    public char getChar(long offset) {
        this.checkOffset(offset, 2L);
        return Unsafer.UNSAFE.getChar(this._address + offset);
    }

    @Override
    public void putChar(long offset, char value) {
        this.checkOffset(offset, 2L);
        Unsafer.UNSAFE.putChar(this._address + offset, value);
    }

    @Override
    public short getShort(long offset) {
        this.checkOffset(offset, 2L);
        return Unsafer.UNSAFE.getShort(this._address + offset);
    }

    @Override
    public void putShort(long offset, short value) {
        this.checkOffset(offset, 2L);
        Unsafer.UNSAFE.putShort(this._address + offset, value);
    }

    @Override
    public int getInt(long offset) {
        this.checkOffset(offset, 4L);
        return Unsafer.UNSAFE.getInt(this._address + offset);
    }

    @Override
    public void putInt(long offset, int value) {
        this.checkOffset(offset, 4L);
        Unsafer.UNSAFE.putInt(this._address + offset, value);
    }

    @Override
    public long getLong(long offset) {
        this.checkOffset(offset, 8L);
        return Unsafer.UNSAFE.getLong(this._address + offset);
    }

    @Override
    public void putLong(long offset, long value) {
        this.checkOffset(offset, 8L);
        Unsafer.UNSAFE.putLong(this._address + offset, value);
    }

    @Override
    public float getFloat(long offset) {
        this.checkOffset(offset, 4L);
        return Unsafer.UNSAFE.getFloat(this._address + offset);
    }

    @Override
    public void putFloat(long offset, float value) {
        this.checkOffset(offset, 4L);
        Unsafer.UNSAFE.putFloat(this._address + offset, value);
    }

    @Override
    public double getDouble(long offset) {
        this.checkOffset(offset, 8L);
        return Unsafer.UNSAFE.getDouble(this._address + offset);
    }

    @Override
    public void putDouble(long offset, double value) {
        this.checkOffset(offset, 8L);
        Unsafer.UNSAFE.putDouble(this._address + offset, value);
    }

    @Override
    public long size() {
        return this._size;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public PinotDataBuffer view(long start, long end, ByteOrder byteOrder) {
        long size = end - start;
        this.checkOffset(start, size);
        UnsafePinotBuffer nativeView = new UnsafePinotBuffer(this._memory, false, this._address + start, size);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return nativeView;
        }
        return new NonNativePinotDataBuffer(nativeView);
    }

    @Override
    public ByteBuffer toDirectByteBuffer(long offset, int size, ByteOrder byteOrder) {
        this.checkOffset(offset, size);
        return ByteBufferUtil.newDirectByteBuffer(this._address + offset, size, this).order(byteOrder);
    }

    @Override
    public void flush() {
        this._memory.flush();
    }

    @Override
    public void release() throws IOException {
        this._memory.close();
    }
}

