/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public abstract class PinotInputStream
extends InputStream
implements DataInput {
    public abstract long getCurrentOffset();

    public abstract void seek(long var1);

    public abstract int read(ByteBuffer var1) throws IOException;

    public String readInt4UTF() throws IOException {
        int length = this.readInt();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public abstract long availableLong();

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        int step = Math.min(this.available(), n);
        this.seek(this.getCurrentOffset() + (long)step);
        return step;
    }

    @Override
    public int available() {
        long available = this.availableLong();
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }
}

