/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class NonNativePinotDataBuffer
extends PinotDataBuffer {
    private final PinotDataBuffer _nativeBuffer;

    public NonNativePinotDataBuffer(PinotDataBuffer nativeBuffer) {
        super(nativeBuffer.isCloseable());
        this._nativeBuffer = nativeBuffer;
    }

    @Override
    public PinotDataBuffer view(long start, long end, ByteOrder byteOrder) {
        PinotDataBuffer nativeView = this._nativeBuffer.view(start, end);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return nativeView;
        }
        return new NonNativePinotDataBuffer(nativeView);
    }

    @Override
    public char getChar(int offset) {
        return Character.reverseBytes(this._nativeBuffer.getChar(offset));
    }

    @Override
    public char getChar(long offset) {
        return Character.reverseBytes(this._nativeBuffer.getChar(offset));
    }

    @Override
    public void putChar(int offset, char value) {
        this._nativeBuffer.putChar(offset, Character.reverseBytes(value));
    }

    @Override
    public void putChar(long offset, char value) {
        this._nativeBuffer.putChar(offset, Character.reverseBytes(value));
    }

    @Override
    public short getShort(int offset) {
        return Short.reverseBytes(this._nativeBuffer.getShort(offset));
    }

    @Override
    public short getShort(long offset) {
        return Short.reverseBytes(this._nativeBuffer.getShort(offset));
    }

    @Override
    public void putShort(int offset, short value) {
        this._nativeBuffer.putShort(offset, Short.reverseBytes(value));
    }

    @Override
    public void putShort(long offset, short value) {
        this._nativeBuffer.putShort(offset, Short.reverseBytes(value));
    }

    @Override
    public int getInt(int offset) {
        return Integer.reverseBytes(this._nativeBuffer.getInt(offset));
    }

    @Override
    public int getInt(long offset) {
        return Integer.reverseBytes(this._nativeBuffer.getInt(offset));
    }

    @Override
    public void putInt(int offset, int value) {
        this._nativeBuffer.putInt(offset, Integer.reverseBytes(value));
    }

    @Override
    public void putInt(long offset, int value) {
        this._nativeBuffer.putInt(offset, Integer.reverseBytes(value));
    }

    @Override
    public long getLong(int offset) {
        return Long.reverseBytes(this._nativeBuffer.getLong(offset));
    }

    @Override
    public long getLong(long offset) {
        return Long.reverseBytes(this._nativeBuffer.getLong(offset));
    }

    @Override
    public void putLong(int offset, long value) {
        this._nativeBuffer.putLong(offset, Long.reverseBytes(value));
    }

    @Override
    public void putLong(long offset, long value) {
        this._nativeBuffer.putLong(offset, Long.reverseBytes(value));
    }

    @Override
    public float getFloat(int offset) {
        return Float.intBitsToFloat(Integer.reverseBytes(this._nativeBuffer.getInt(offset)));
    }

    @Override
    public float getFloat(long offset) {
        return Float.intBitsToFloat(Integer.reverseBytes(this._nativeBuffer.getInt(offset)));
    }

    @Override
    public void putFloat(int offset, float value) {
        this._nativeBuffer.putInt(offset, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloat(long offset, float value) {
        this._nativeBuffer.putInt(offset, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public double getDouble(int offset) {
        return Double.longBitsToDouble(Long.reverseBytes(this._nativeBuffer.getLong(offset)));
    }

    @Override
    public double getDouble(long offset) {
        return Double.longBitsToDouble(Long.reverseBytes(this._nativeBuffer.getLong(offset)));
    }

    @Override
    public void putDouble(int offset, double value) {
        this._nativeBuffer.putLong(offset, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDouble(long offset, double value) {
        this._nativeBuffer.putLong(offset, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public ByteOrder order() {
        return NON_NATIVE_ORDER;
    }

    @Override
    public byte getByte(int offset) {
        return this._nativeBuffer.getByte(offset);
    }

    @Override
    public byte getByte(long offset) {
        return this._nativeBuffer.getByte(offset);
    }

    @Override
    public void putByte(int offset, byte value) {
        this._nativeBuffer.putByte(offset, value);
    }

    @Override
    public void putByte(long offset, byte value) {
        this._nativeBuffer.putByte(offset, value);
    }

    @Override
    public void copyTo(long offset, byte[] buffer, int destOffset, int size) {
        this._nativeBuffer.copyTo(offset, buffer, destOffset, size);
    }

    @Override
    public void copyTo(long offset, byte[] buffer) {
        this._nativeBuffer.copyTo(offset, buffer);
    }

    @Override
    public void copyTo(long offset, DataBuffer buffer, long destOffset, long size) {
        this._nativeBuffer.copyTo(offset, buffer, destOffset, size);
    }

    @Override
    public void readFrom(long offset, byte[] buffer, int srcOffset, int size) {
        this._nativeBuffer.readFrom(offset, buffer, srcOffset, size);
    }

    @Override
    public void readFrom(long offset, byte[] buffer) {
        this._nativeBuffer.readFrom(offset, buffer);
    }

    @Override
    public void readFrom(long offset, ByteBuffer buffer) {
        this._nativeBuffer.readFrom(offset, buffer);
    }

    @Override
    public void readFrom(long offset, File file, long srcOffset, long size) throws IOException {
        this._nativeBuffer.readFrom(offset, file, srcOffset, size);
    }

    @Override
    public ByteBuffer toDirectByteBuffer(long offset, int size, ByteOrder byteOrder) {
        return this._nativeBuffer.toDirectByteBuffer(offset, size, byteOrder);
    }

    @Override
    public long size() {
        return this._nativeBuffer.size();
    }

    @Override
    public void flush() {
        this._nativeBuffer.flush();
    }

    @Override
    public void release() throws IOException {
        this._nativeBuffer.release();
    }
}

